/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   STB layer initialisation routine
 *
 * @file    stbinit.c
 * @date    16/10/2000
 */

//---includes for this file----------------------------------------------------
// compiler library header files

// third party header files

// Ocean Blue Software header files
#include <techtype.h>
#include <dbgfuncs.h>

#include "stbhwfp.h"
#include "stbhwini.h"
#include "stbgc.h"
#include "stbdpc.h"
#include "stberc.h"
#include "stbheap.h"
#include "stbsic.h"

#include "stbpvr.h"

#include "stbpes.h"
#include "stbebutt.h"
#include "stbvbi.h"
#include "stbds.h"
#include "stbresmgr.h"
#include "stbhwos.h"

#include "stbinit.h"
#include "stbvtc.h"

#include "ca_glue.h"

//---macro definitions for this file-------------------------------------------

//---constant definitions for this file----------------------------------------

//---local typedef structs for this file---------------------------------------

//---local (static) variable declarations for this file------------------------
//   (internal variables declared static to make them local)

//---global variable definitions-----------------------------------------------

//---local function prototypes for this file-----------------------------------
//   (internal functions declared static to make them local)

//---local function definitions------------------------------------------------

//---global function definitions-----------------------------------------------

/**
 *

 *
 * @brief   Initialises STB layer.
 *
 * @param   U32BIT nvm_size - the number of bytes required in NVM by the application
 *

 *
 */
void STB_Initialise(E_STB_TTXT_SUBT_CONTROL ttxt_subt_cntrl)
{
   BOOLEAN heap_initialised = FALSE;

   FUNCTION_START(STB_Initialise);

   switch (ttxt_subt_cntrl)
   {
      case EBU_SUBTITLES:
         STB_HWInitialise(HW_SUBT_EBU);
         break;

      case DVB_SUBTITLES:
         STB_HWInitialise(HW_SUBT_DVB);
         STB_HeapInitialise();
         heap_initialised = TRUE;
         STB_PesCollectionTaskInitialise();
         STB_SUBInitialise();
         break;

      case DVB_SUBTITLES_AND_TELETEXT:
         STB_HWInitialise(HW_SUBT_EBU | HW_SUBT_DVB);
         STB_HeapInitialise();
         heap_initialised = TRUE;
         STB_PesCollectionTaskInitialise();
         STB_SUBInitialise();
         STB_EBUTT_Initialise();
         break;

      case DECODED_TELETEXT_WITH_VBI:
         STB_HWInitialise(HW_SUBT_NONE);
         STB_HeapInitialise();
         heap_initialised = TRUE;
         STB_PesCollectionTaskInitialise();
         STB_EBUTT_Initialise();
         STB_VBIInitialise();
         break;

      case DECODED_TELETEXT_WITHOUT_VBI:
         STB_HWInitialise(HW_SUBT_NONE);
         STB_HeapInitialise();
         heap_initialised = TRUE;
         STB_PesCollectionTaskInitialise();
         STB_EBUTT_Initialise();
         break;

      case VBI_TELETEXT:
         STB_HWInitialise(HW_SUBT_NONE);
         STB_HeapInitialise();
         heap_initialised = TRUE;
         STB_PesCollectionTaskInitialise();
         STB_VBIInitialise();
         break;

      default:
         STB_HWInitialise(HW_SUBT_NONE);
         break;
   }

   if (heap_initialised == FALSE)
   {
      STB_HeapInitialise();
   }

   STB_GCInitialise();

   STB_RESInitialise();
   STB_DPInitialise();
   STB_VTInitialise();

   STB_SITerrInitialise();

   STB_PVRInitialise();

   STB_CAInitialise();

   FUNCTION_FINISH(STB_Initialise);
}

//*****************************************************************************
// End of file
//*****************************************************************************

