/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2007 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   STB middleware resource management module header file.
 * @file    stbresmgr.h
 * @date    June 2007
 * @author  Steve Ford
 */

#ifndef _STBRESMGR_H
#define _STBRESMGR_H

#include "techtype.h"
#include "stbdpc.h"

#ifndef INVALID_RES_ID
#define INVALID_RES_ID     ((U8BIT)0xFF)     /* ID used to represent an invalid resource */
#endif


BOOLEAN STB_RESInitialise(void);

U8BIT STB_RESNumTuners(void);
U8BIT STB_RESAcquireTuner(E_STB_DP_SIGNAL_TYPE tuner_type, void *transport, E_STB_DP_RES_OWNER owner,
   BOOLEAN high_priority, BOOLEAN *tuner_taken);
void STB_RESReleaseTuner(U8BIT tuner_id, BOOLEAN high_priority, E_STB_DP_RES_OWNER owner);

/**
 * @brief   Set the disable state for a tuner. When disabled, a tuner will be ignored when
 *          acquiring a new tuner resource
 * @param   tuner_id ID of tuner
 * @param   disable TRUE if the tuner is to be disabled, FALSE otherwise
 */
void STB_RESSetTunerDisabled(U8BIT tuner_id, BOOLEAN disable);

/**
 * @brief   Returns whether a tuner has been disabled or not
 * @param   tuner_id ID of tuner
 * @return  TRUE if the tuner is disabled, FALSE otherwise
 */
BOOLEAN STB_RESIsTunerDisabled(U8BIT tuner_id);

/**
 * @brief   Returns the number of tuners that aren't disabled
 * @return  number of enabled tuners
 */
U8BIT STB_RESNumEnabledTuners(void);

void STB_RESSetTunerOwner(U8BIT tuner_id, E_STB_DP_RES_OWNER owner);
E_STB_DP_SIGNAL_TYPE STB_RESGetTunerType(U8BIT tuner_id);
void STB_RESSetTunedTransport(U8BIT tuner_id, void *t_ptr);
void* STB_RESGetTunedTransport(U8BIT tuner_id);
BOOLEAN STB_RESCanTuneToTransport(E_STB_DP_SIGNAL_TYPE tuner_type, void *transport);
U8BIT STB_RESTunerUsageCount(U8BIT tuner_id);

U8BIT STB_RESNumDemuxes(void);
U8BIT STB_RESAcquireDemux(U8BIT demux_id, U16BIT caps);
void STB_RESReleaseDemux(U8BIT demux_id);
U16BIT STB_RESGetDemuxCaps(U8BIT demux_id);

U8BIT STB_RESNumAudioDecoders(void);
U8BIT STB_RESAcquireAudioDecoder(void);
void STB_RESReleaseAudioDecoder(U8BIT decoder_id);

U8BIT STB_RESAcquireADDecoder(void);
void STB_RESReleaseADDecoder(U8BIT decoder_id);
U8BIT STB_RESNumVideoDecoders(void);
U8BIT STB_RESAcquireVideoDecoder(void);
void STB_RESReleaseVideoDecoder(U8BIT decoder_id);

U8BIT STB_RESNumCISlots(void);
U8BIT STB_RESAcquireCISlot(void *service, U8BIT *pmt_data, U8BIT *ci_protection_desc);
BOOLEAN STB_RESUseCISlot(U8BIT slot_id);
U8BIT STB_RESGetCISlotUsageCount(U8BIT slot_id);
void STB_RESReleaseCISlot(U8BIT slot_id);
#endif /* _STBRESMGR_H */
