/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - macros and function prototypes for public use
 *
 * @file    stbsic.h
 * @date    01/03/2001
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error

#ifndef _STBSIC_H

#define _STBSIC_H

#include "techtype.h"

//---Constant and macro definitions for public use-----------------------------

#define SI_EVENT_SEARCH             0x00000001
#define SI_EVENT_UPDATE             0x00000002
#define SI_EVENT_SERVICE_CHANGE     0x00000004
#define SI_EVENT_EXTENDED_EVENT     0x00000008
#define SI_EVENT_STOP               0x00000010
#define SI_EVENT_ACTION_FILTER      0x00000020

//---Enumerations for public use-----------------------------------------------

//---Global type defs for public use-------------------------------------------

typedef enum
{
   SI_SEARCHING,
   SI_UPDATING,
   SI_STOPPED
} E_STB_SI_STATUS;

//---Global Function prototypes for public use---------------------------------

#if 0
void STB_SIInitialise(void);
void STB_SISendEvent(U8BIT path, U32BIT events);
E_STB_SI_STATUS STB_SIGetStatus(U8BIT path);
#endif

void STB_SITerrInitialise(void);
void STB_SITerrSendEvent(U8BIT path, U32BIT events);
E_STB_SI_STATUS STB_SITerrGetStatus(U8BIT path);

#endif //  _STBSIC_H

//*****************************************************************************
// End of file
//*****************************************************************************
