/*******************************************************************************
 * Copyright © 2017 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/

#ifndef _STBHWCAS_H
#define _STBHWCAS_H


/*--- Includes ----------------------------------------------------------------*/
#include "techtype.h"
#include "dbgfuncs.h"

#ifdef __cplusplus
extern "C" {
#endif

/*--- Preprocessor definitions ------------------------------------------------*/

/*--- Global types definitions ------------------------------------------------*/

/*--- Global function declarations --------------------------------------------*/

/**
 * @brief   Initialises encryption/decryption
 * @return  TRUE if initialisation is successful, FALSE otherwise
 */
BOOLEAN STB_CASInitialise(void);

/*!**************************************************************************
 * @brief   When there's an update to the CAT for a service, the updated CAT
 *          will be reported to the CA system using this function.
 * @param   path - decode path
 * @param   handle - CA descrambler handle
 * @param   ca_system_id - CA system ID
 * @param   pid - the EMM PID
 ****************************************************************************/
void STB_CASSetEmmPid(U8BIT path, U32BIT handle, U16BIT ca_system_id, U16BIT pid);

BOOLEAN STB_CASStartDescrambler(U32BIT handle);
BOOLEAN STB_CASStopDescrambler(U32BIT handle);

#ifdef __cplusplus
}
#endif

#endif /*  _STBHWCAS_H */

/****************************************************************************
** End of file
*****************************************************************************/

