/* Output the two static dependancy files: .E and .Q  */
/* These are later included in *.P files by sunrise
 * make script immediately after compilation */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

int main(int argc, char *argv[])
{
   FILE *out;
   int flen;
   char *tag, *fnm;
   if (argc != 3)
   {
      fprintf(stderr, "Usage:\n\t%s <source name tag> <E output file>\n", argv[0]);
      return -1;
   }
   else
   {
      tag = argv[1];
      fnm = argv[2];
      flen = strlen(fnm);
      out = fopen(fnm, "w+");
      if (out == NULL)
      {
         fprintf(stderr, "failed to open file %s\n", fnm);
         return -2;
      }
      else
      {
         fprintf(out, "DIFS_%s := $(filter-out $(DEFINES),$(ODEFS_%s)) $(filter-out $(ODEFS_%s),$(DEFINES))\n", tag, tag, tag);
         fprintf(out, "ifneq ($(strip $(DIFS_%s)),)\n", tag);
         fprintf(out, "ifneq ($(strip $(filter $(subst =, ,$(DIFS_%s)),$(FDEPS_%s))),)\n", tag, tag);
         fprintf(out, "FORCE_%s = force\nendif\nendif\n", tag);
         fclose(out);
      }
      fnm[flen - 1] = 'Q';
      out = fopen(fnm, "w+");
      if (out == NULL)
      {
         fprintf(stderr, "failed to open file %s\n", fnm);
         return -3;
      }
      else
      {
         fprintf(out, " $(FORCE_%s)\n", tag);
         fclose(out);
      }
      return 0;
   }
}

