#****************************************************************************
#*  Copyright (c) 2007 Ocean Blue Software Ltd. - ALL RIGHTS RESERVED
#*  This document is the CONFIDENTIAL property of Ocean Blue Software Ltd.
#****************************************************************************
#* @brief    Replaces version strings in a file with those set in the
#*	     shell environment variables
#* @file     version.awk
#* @Date     15th November 2007
#* @Author   Omri Barel
#****************************************************************************/

BEGIN { state = 0 }

# Print application version string
function print_app_version_string()
{
   printf "/* %%%%%% MODIFIED_AUTOMATIC_VERSION_STRING %%%%%% */\n" \
           "static const U8BIT* app_sw_ver_no_str = (U8BIT*)\"%s.%s.%s\\n%s/%s/%s\";\n", \
	ENVIRON["APP_VERSION_MAJOR"], \
	ENVIRON["APP_VERSION_MINOR"], \
	ENVIRON["APP_VERSION_REVISION"], \
	ENVIRON["APP_BUILD_DAY"], \
	ENVIRON["APP_BUILD_MONTH"], \
	ENVIRON["APP_BUILD_YEAR"]
}

# Print application version struct
function print_app_version_struct()
{
   printf "/* %%%%%% MODIFIED_AUTOMATIC_VERSION_STRUCT %%%%%% */\n" \
           "static const APP_SW_VER_STRUCT app_sw_ver_number = {0, %s, %s, 0, %s};\n", \
	ENVIRON["APP_VERSION_MAJOR"], \
	ENVIRON["APP_VERSION_MINOR"], \
	ENVIRON["APP_VERSION_REVISION"]
}

{
  if (state == 1)
  {
    # Previous line was MODIFIED_AUTOMATIC_VERSION_STRING, so modify it again
    print_app_version_string()
    state = 0
  }
  else if (state == 2)
  {
    # Previous line was MODIFIED_AUTOMATIC_VERSION_STRUCT, so modify it again
    print_app_version_struct()
    state = 0
  }
  else if (/\/\* %%% MODIFIED_AUTOMATIC_VERSION_STRING.* %%% \*\//)
  {
     state = 1
  }
  else if (/\/\* %%% MODIFIED_AUTOMATIC_VERSION_STRUCT.* %%% \*\//)
  {
     state = 2
  }
  else if (/\/\* %%% AUTOMATIC_VERSION_STRING.* %%% \*\//)
  {
    print_app_version_string()
    state = 0
  }
  else if (/\/\* %%% AUTOMATIC_VERSION_STRUCT.* %%% \*\//)
  {
    print_app_version_struct()
    state = 0
  }
  else
  {
    # Print default line
    print
    state = 0
  }
}


