# DTVKit Android

## Build and installation
1. Clone the DTVKit Android components and overlay DVBCore and the DTVKit platform
```
cd $ANDROID_BUILD_TOP
git clone https://github.com/DTVKit/android vendor/dtvkit
git clone https://github.com/DTVKit/DVBCore vendor/dtvkit/DVBCore/DVBCore
git clone https://github.com/DTVKit/your-platform vendor/dtvkit/your-platform
```
2. Build DVBCore
```
mmm vendor/dtvkit/DVBCore
```
3. Build the DTVKit platform
```
mmm vendor/dtvkit/your-platform
```
4. Build the DTVKit service
```
mmm vendor/dtvkit/interfaces/dtvkit/1.0
mmm vendor/dtvkit/interfaces/dtvkit/1.0/default
```
5. Build the inputsource app
```
mmm vendor/dtvkit/apps/inputsource
```
6. Add the following to the device manifest
```
 <hal format="hidl">
     <name>vendor.dtvkit.hardware.dtvkit</name>
     <transport>hwbinder</transport>
     <version>1.0</version>
     <interface>
         <name>IDTVKit</name>
         <instance>default</instance>
     </interface>
 </hal>
```
7. Generate hashes using the `hidl-gen` command for the DTVKit HIDL interfaces and add them to the `current.txt` (or similar) for your device
```
hidl-gen -Lhash -rvendor.dtvkit.hardware:vendor/dtvkit/interfaces -randroid.hidl:system/libhidl/transport vendor.dtvkit.hardware.dtvkit@1.0
```
