#include <jni.h>
#include <JNIHelp.h>
#include <android/native_window_jni.h>
#include <android/log.h>
#include <string.h>

#include <vendor/dtvkit/hardware/dtvkit/1.0/IDTVKit.h>
#include "android_runtime/android_view_Surface.h"

#include <gui/IGraphicBufferProducer.h>
#include <gui/bufferqueue/1.0/H2BGraphicBufferProducer.h>
#include <gui/bufferqueue/1.0/WGraphicBufferProducer.h>
#include <gui/Surface.h>

#ifdef PLATFORM_BROADCOM
#include <cutils/native_handle.h>
#include <bcmsideband.h>
#include <bcmsidebandplayerfactory.h>
static struct bcmsideband_ctx *context = NULL;
#elif PLATFORM_HISILICON
#include <cutils/native_handle.h>
#include <system/window.h>
static native_handle_t* pstSideBandHandle = NULL;
#endif

#define TAG "DTVKit-JNI"

#define LOGV(...) __android_log_print(ANDROID_LOG_VERBOSE, TAG , __VA_ARGS__)
#define LOGD(...) __android_log_print(ANDROID_LOG_DEBUG , TAG , __VA_ARGS__)
#define LOGI(...) __android_log_print(ANDROID_LOG_INFO  , TAG , __VA_ARGS__)
#define LOGW(...) __android_log_print(ANDROID_LOG_WARN  , TAG , __VA_ARGS__)
#define LOGE(...) __android_log_print(ANDROID_LOG_ERROR  , TAG , __VA_ARGS__)

using namespace android;
using ::android::hardware::graphics::bufferqueue::V1_0::utils::H2BGraphicBufferProducer;

static jlong videoWindowHandle = 0;
static jboolean set = JNI_FALSE;
static int surface_x = 0;
static int surface_y = 0;
static int surface_width = 1920;
static int surface_height = 1080;

#ifdef PLATFORM_BROADCOM
static void onRectangleUpdated(void *context, unsigned int x, unsigned int y, unsigned int width, unsigned int height)
{
   __android_log_print(ANDROID_LOG_INFO, "DTVKitSource", "onRectangleUpdated: x %d, y %d, width %d, height %d\n",
      x, y, width, height);
   surface_x = x;
   surface_y = y;
   surface_width = width;
   surface_height = height;
}
#endif

extern "C" JNIEXPORT jboolean JNICALL
Java_org_dtvkit_inputsource_Platform_setNativeSurface(JNIEnv *env, jclass thiz, jobject surface)
{
   if (set != JNI_TRUE)
   {
      ANativeWindow *window = ANativeWindow_fromSurface(env, surface);
#ifdef PLATFORM_BROADCOM
      __android_log_print(ANDROID_LOG_INFO, "DTVKitSource", "setNativeSurface: Broadcom platform selected (width %d, height %d)\n",
         ANativeWindow_getWidth(window), ANativeWindow_getHeight(window));
      int index = 0, videoId = -1, audioId = -1, surfaceId = -1;
      if ((context = libbcmsideband_init_sideband(index, window, &videoId, &audioId, &surfaceId, &onRectangleUpdated)))
      {
         set = JNI_TRUE;
      }
#elif PLATFORM_HISILICON
      __android_log_print(ANDROID_LOG_INFO, "DTVKitSource", "setNativeSurface: HiSilicon platform selected (width %d, height %d)\n",
         ANativeWindow_getWidth(window), ANativeWindow_getHeight(window));

      pstSideBandHandle = native_handle_create(0, 1);

      __android_log_print(ANDROID_LOG_INFO, "DTVKitSource", "video handle is %lld\n", videoWindowHandle);

      if (videoWindowHandle != 0)
      {
         pstSideBandHandle->data[0] = videoWindowHandle;

         native_window_set_sideband_stream(window, pstSideBandHandle);
         set = JNI_TRUE;
      }
      else
      {
         set = JNI_FALSE;
      }
#elif PLATFORM_REALTEK
      set = JNI_TRUE;
#else
      __android_log_print(ANDROID_LOG_WARN, "DTVKitSource",
                          "setNativeSurface: no platform selected (width %d, height %d)\n",
                          ANativeWindow_getWidth(window), ANativeWindow_getHeight(window));
      ANativeWindow_setBuffersGeometry(window, surface_width, surface_height,
                                       WINDOW_FORMAT_RGBA_8888);
      ANativeWindow_Buffer buffer;
      if (ANativeWindow_lock(window, &buffer, 0) == 0)
      {
         memset(buffer.bits, 0x00, surface_width * surface_height * 4);
         ANativeWindow_unlockAndPost(window);
      }
      set = JNI_TRUE;
#endif
   }

   return set;
}

extern "C" JNIEXPORT void JNICALL
Java_org_dtvkit_inputsource_Platform_unsetNativeSurface(JNIEnv *env, jclass thiz)
{
   if (set == JNI_TRUE)
   {
#ifdef PLATFORM_BROADCOM
      libbcmsideband_release(context);
      context = NULL;
#elif PLATFORM_HISILICON
      native_handle_delete(pstSideBandHandle);
      pstSideBandHandle = NULL;
#endif
      set = JNI_FALSE;
   }
}

extern "C" JNIEXPORT jint JNICALL
Java_org_dtvkit_inputsource_Platform_getNativeSurfaceX(JNIEnv *env, jobject instance)
{
   return surface_x;
}

extern "C" JNIEXPORT jint JNICALL
Java_org_dtvkit_inputsource_Platform_getNativeSurfaceY(JNIEnv *env, jobject instance)
{
   return surface_y;
}

extern "C" JNIEXPORT jint JNICALL
Java_org_dtvkit_inputsource_Platform_getNativeSurfaceWidth(JNIEnv *env, jobject instance)
{
   return surface_width;
}

extern "C" JNIEXPORT jint JNICALL
Java_org_dtvkit_inputsource_Platform_getNativeSurfaceHeight(JNIEnv *env, jobject instance)
{
   return surface_height;
}

extern "C" JNIEXPORT void JNICALL
Java_org_dtvkit_inputsource_Platform_setNativeVideoWindowHandle(JNIEnv *env, jobject instance,
   jlong handle)
{
   videoWindowHandle = handle;
}

extern "C" JNIEXPORT jint JNICALL
Java_org_dtvkit_inputsource_Platform_setNativeVideoSurface (
   JNIEnv* env,
   jobject obj,
   jint type,
   jobject jsurface,
   jboolean is_pip
)
{
	//UNUSED(obj);
	sp<IGraphicBufferProducer> bufferProducer;
    sp<Surface> surface;
    sp<HGraphicBufferProducer> igbp;
    sp<vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKit> spIDTVKitService;
	int iRet = -1;

	if (jsurface == NULL)
        goto error;

	surface = android_view_Surface_getSurface(env, jsurface);
	if (surface == NULL) {
		jniThrowException(env, "java/lang/IllegalArgumentException",
			"The surface has been released");
        goto error;
    }
	bufferProducer = surface->getIGraphicBufferProducer();
	if (bufferProducer == NULL) {
		jniThrowException(env, "java/lang/IllegalArgumentException",
			"The surface does not have a binding SurfaceTexture!");
		goto error;
	}
	
    igbp = new TWGraphicBufferProducer<HGraphicBufferProducer>(bufferProducer);
    if (igbp == NULL)
        goto error;

    spIDTVKitService = 
        vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKit::getService();
    if (spIDTVKitService == NULL)
        goto error;

    spIDTVKitService->setVideoSurface(type, igbp, is_pip);
    iRet = 0;

error:
   return iRet;
}
