package com.hwacom.dtv;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;

import org.dtvkit.inputsource.R;

public class SearchChannel extends Activity {
    private String TAG = "DTV-SearchChannel";

    private ListView lvSearchChanel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.search_channel);

        setSettingsLeft();
    }

    private RelativeLayout rlSettingList, rlSearchChannel;
    private EditText etFrequency,etSR;
    private Button btnQAM;

    private String[] qamItems;

    private void setSettingsLeft() {
        rlSettingList = (RelativeLayout) findViewById(R.id.rlSettingList);
        rlSearchChannel = (RelativeLayout) findViewById(R.id.rlSearchChannel);

        etFrequency = (EditText) findViewById(R.id.etFrequency);
        etSR = (EditText) findViewById(R.id.etSR);

        btnQAM = (Button) findViewById(R.id.btnQAM);

        etFrequency.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_blue_line);
                } else {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_gary_line);
                }
            }

        });

        etSR.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_blue_line);
                } else {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_gary_line);
                }
            }

        });


        btnQAM.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_blue_line);
                } else {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_gary_line);
                }
            }

        });

        String[] settingItems = getResources().getStringArray(R.array.search_channel_list);

        lvSearchChanel = (ListView) findViewById(R.id.lvSearchChanel);

        ListAdapter adapter = new ArrayAdapter<String>(this, R.layout.list_item, settingItems);
        lvSearchChanel.setAdapter(adapter);

        lvSearchChanel.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                showSettingsRight(position);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });

        lvSearchChanel.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                showSettingsRight(position);
            }
        });

        lvSearchChanel.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                    rlSettingList.setBackgroundResource(R.drawable.round_corner_square_blue_line);
                } else {
                    rlSettingList.setBackgroundResource(R.drawable.round_corner_square_gary_line);
                }
            }

        });

        qamItems = getResources().getStringArray(R.array.qam_list);

        btnQAM.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        //rlSettingList.requestFocus();
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {

                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
                        nextResolution(keyCode);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private int qamIndex = 0;

    private void nextResolution(int keyCode) {
        if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
            qamIndex = qamIndex - 1;
            if (qamIndex == -1) {
                qamIndex = qamItems.length - 1;
            }
        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
            qamIndex = qamIndex + 1;
            if (qamIndex == qamItems.length) {
                qamIndex = 0;
            }
        } else {

        }

        btnQAM.setText(qamItems[qamIndex]);
    }

    private void showSettingsRight(int index) {
        switch (index) {
            case 0:
                break;
            case 1:
                break;
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_UP || keyCode == KeyEvent.KEYCODE_CHANNEL_UP) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_DOWN || keyCode == KeyEvent.KEYCODE_CHANNEL_DOWN) {

        } else if (keyCode == KeyEvent.KEYCODE_MENU || keyCode == KeyEvent.KEYCODE_INFO) {

        } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_RED) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_GREEN) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_BLUE) {

        } else if (keyCode == KeyEvent.KEYCODE_GUIDE) {

        } else if (keyCode == KeyEvent.KEYCODE_MEDIA_AUDIO_TRACK) {

        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        Log.d(TAG, "onPause");
        super.onPause();
    }
}
