package com.hwacom.dtv;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.TextView;

import org.dtvkit.inputsource.R;

public class SearchChannelSetup extends Activity {
    private String TAG = "DTV-SearchChannelSetup";

    private String SEARCH_FREQUENCY, SEARCH_SR, SEARCH_QAM;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.search_channel_setup);

        Bundle bundle = this.getIntent().getExtras();

        SEARCH_FREQUENCY = bundle.getString("Frequency");
        SEARCH_SR = bundle.getString("SR");
        SEARCH_QAM = bundle.getString("QAM");

        setSettingsLeft();

        //TODO
        // 0 search ok, 1 search fault
        int resultCode = 0;
        this.setResult(resultCode);
    }

    private TextView tvFrequency, tvSR, tvQAM;

    private void setSettingsLeft() {
        tvFrequency = (TextView) findViewById(R.id.tvFrequency);
        tvSR = (TextView) findViewById(R.id.tvSR);
        tvQAM = (TextView) findViewById(R.id.tvQAM);

        tvFrequency.setText(SEARCH_FREQUENCY);
        tvSR.setText(SEARCH_SR);
        tvQAM.setText(SEARCH_QAM);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_UP || keyCode == KeyEvent.KEYCODE_CHANNEL_UP) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_DOWN || keyCode == KeyEvent.KEYCODE_CHANNEL_DOWN) {

        } else if (keyCode == KeyEvent.KEYCODE_MENU || keyCode == KeyEvent.KEYCODE_INFO) {

        } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_RED) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_GREEN) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_BLUE) {

        } else if (keyCode == KeyEvent.KEYCODE_GUIDE) {

        } else if (keyCode == KeyEvent.KEYCODE_MEDIA_AUDIO_TRACK) {

        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        Log.d(TAG, "onPause");
        super.onPause();
    }
}
