package com.hwacom.dtv;

import android.app.Activity;
import android.app.Instrumentation;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

import org.dtvkit.inputsource.R;

public class SignalDetection extends Activity {
    private String TAG = "DTV-SignalDetection";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.signal_detection);

        setSettingsLeft();
    }

    private EditText etFrequency,etSR;
    private Button btnQAM;

    private String[] qamItems;

    private void setSettingsLeft() {
        etFrequency = (EditText) findViewById(R.id.etFrequency);
        etSR = (EditText) findViewById(R.id.etSR);

        btnQAM = (Button) findViewById(R.id.btnQAM);

        qamItems = getResources().getStringArray(R.array.qam_list);

        etFrequency.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etFrequency.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        etSR.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etSR.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        btnQAM.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        //rlSettingList.requestFocus();
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {

                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
                        nextResolution(keyCode);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private int qamIndex = 0;

    private void nextResolution(int keyCode) {
        if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
            qamIndex = qamIndex - 1;
            if (qamIndex == -1) {
                qamIndex = qamItems.length - 1;
            }
        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
            qamIndex = qamIndex + 1;
            if (qamIndex == qamItems.length) {
                qamIndex = 0;
            }
        } else {

        }

        btnQAM.setText(qamItems[qamIndex]);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_UP || keyCode == KeyEvent.KEYCODE_CHANNEL_UP) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_DOWN || keyCode == KeyEvent.KEYCODE_CHANNEL_DOWN) {

        } else if (keyCode == KeyEvent.KEYCODE_MENU || keyCode == KeyEvent.KEYCODE_INFO) {

        } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_RED) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_GREEN) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_BLUE) {

        } else if (keyCode == KeyEvent.KEYCODE_GUIDE) {

        } else if (keyCode == KeyEvent.KEYCODE_MEDIA_AUDIO_TRACK) {

        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        Log.d(TAG, "onPause");
        super.onPause();
    }
}
