package com.hwacom.dtv;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RecoverySystem;
import android.os.SystemProperties;
import android.util.Log;
import android.view.KeyEvent;
import android.widget.ProgressBar;
import android.widget.TextView;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;

import org.dtvkit.inputsource.R;

public class Update extends Activity {
    private String TAG = "DTV-Update";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.system_update);

        setUpdate();
        startDownloadUpdate();
    }

    private TextView tvUpdateStatus, tvDownloadPercent, tvWritePercent, tvCheckPercent;
    private ProgressBar pbDownloadStatus, pbCheckStatus, pbWriteStatus;
    private TextView tvSoftwareVersion, tvNowVersion, tvUpdateVersion;
    private Handler mHandler;

    private void setUpdate() {
        tvUpdateStatus = (TextView) findViewById(R.id.tvUpdateStatus);
        tvDownloadPercent = (TextView) findViewById(R.id.tvDownloadPercent);
        tvWritePercent = (TextView) findViewById(R.id.tvWritePercent);
        tvCheckPercent = (TextView) findViewById(R.id.tvCheckPercent);

        pbDownloadStatus = (ProgressBar) findViewById(R.id.pbDownloadStatus);
        pbCheckStatus = (ProgressBar) findViewById(R.id.pbCheckStatus);
        pbWriteStatus = (ProgressBar) findViewById(R.id.pbWriteStatus);

        tvSoftwareVersion = (TextView) findViewById(R.id.tvSoftwareVersion);
        tvNowVersion = (TextView) findViewById(R.id.tvNowVersion);
        tvUpdateVersion = (TextView) findViewById(R.id.tvUpdateVersion);

        mHandler = new Handler() {
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                Log.d(TAG, "handleMessage - " + msg.what);
                if (msg.what == REBOOT_INSTALL) {
                    Log.d(TAG, "Complete, start to upgrade ...");
                    rebootInstall();
                } else if (msg.what == VERIFY_PACKAGE_FAIL) {
                    Log.d(TAG, "Verify package fail ...");

                    verifyPackageFail();
                } else if (msg.what == UPDATE_CHECK_PROGRESS) {
                    pbCheckStatus.setProgress(msg.arg1);
                    tvCheckPercent.setText(msg.arg1 + "%");
                }
            }
        };
    }

    private String FILE_NAME = "update.zip";
    private String FILE_PATH = "/cache/";

    private void startDownloadUpdate() {
        String path = new String(FILE_PATH + FILE_NAME);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }

        //start download
        //TODO

        tvUpdateStatus.setText(getString(R.string.downloading));

        pbDownloadStatus.setMax(100);
        pbDownloadStatus.setProgress(0);
        pbCheckStatus.setMax(100);
        pbCheckStatus.setProgress(0);
        pbWriteStatus.setMax(100);
        pbWriteStatus.setProgress(0);

        tvDownloadPercent.setText("0%");
        tvCheckPercent.setText("0%");
        tvWritePercent.setText("0%");

        tvSoftwareVersion.setText("");
        String nowVersion = SystemProperties.get("ro.build.display.id");
        tvNowVersion.setText(nowVersion);
        //TODO
        String updateVersion = "";
        tvUpdateVersion.setText(updateVersion);
    }

    //TODO
    private void updateDownloadPercent(int percent) {
        pbDownloadStatus.setProgress(percent);
        tvDownloadPercent.setText(percent + "%");

        if (percent == 100) {
            startCheck();
        }
    }

    private int REBOOT_INSTALL = 99999;
    private int VERIFY_PACKAGE_FAIL = 99998;
    private int UPDATE_CHECK_PROGRESS = 99997;

    final File file = new File(FILE_PATH + FILE_NAME);

    private void startCheck() {
        tvUpdateStatus.setText(getString(R.string.checking));

        Thread thread = new Thread("verifyPackage") {
            @Override
            public void run() {
                try {
                    RecoverySystem.verifyPackage(file,
                            new RecoverySystem.ProgressListener() {
                                @Override
                                public void onProgress(int progress) {
                                    Message message = new Message();
                                    message.what = UPDATE_CHECK_PROGRESS;
                                    message.arg1 = progress;
                                    mHandler.sendMessage(message);

                                    if (progress == 100) {
                                        message = new Message();
                                        message.what = REBOOT_INSTALL;
                                        mHandler.sendMessage(message);
                                    }
                                }
                            }, null);
                } catch (IOException e) {
                    Message message = new Message();
                    message.what = VERIFY_PACKAGE_FAIL;
                    mHandler.sendMessage(message);
                    e.printStackTrace();
                } catch (GeneralSecurityException e) {
                    Message message = new Message();
                    message.what = VERIFY_PACKAGE_FAIL;
                    mHandler.sendMessage(message);
                    e.printStackTrace();
                }
            }
        };
        thread.start();

    }

    private void verifyPackageFail() {
        tvUpdateStatus.setText(getString(R.string.check_fall));

        if (file.exists()) {
            file.delete();
        }

        updateFail();
    }

    private void rebootInstall() {
        tvUpdateStatus.setText(getString(R.string.writing));

        Thread thread = new Thread("Reboot") {
            @Override
            public void run() {
                try {
                    pbWriteStatus.setProgress(100);
                    tvWritePercent.setText("100%");
                    tvUpdateStatus.setText(getString(R.string.reboot));

                    RecoverySystem.installPackage(Update.this, file);
                } catch (IOException e) {
                    pbWriteStatus.setProgress(100);
                    tvWritePercent.setText("100%");
                    tvUpdateStatus.setText(getString(R.string.install_fall));

                    Log.e(TAG, "can not run installPackage", e);
                    updateFail();
                }

            }
        };
        thread.start();
    }

    private Handler handler = new Handler();

    private void updateFail() {
        handler.postDelayed(new Runnable() {
            public void run() {
                //TODO
                finish();
            }
        }, 3000);

    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_UP || keyCode == KeyEvent.KEYCODE_CHANNEL_UP) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_DOWN || keyCode == KeyEvent.KEYCODE_CHANNEL_DOWN) {

        } else if (keyCode == KeyEvent.KEYCODE_MENU || keyCode == KeyEvent.KEYCODE_INFO) {

        } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_RED) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_GREEN) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_BLUE) {

        } else if (keyCode == KeyEvent.KEYCODE_GUIDE) {

        } else if (keyCode == KeyEvent.KEYCODE_MEDIA_AUDIO_TRACK) {

        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        Log.d(TAG, "onPause");
        super.onPause();
    }
}
