package org.dtvkit.inputsource;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Log;

import java.lang.Long;

import org.dtvkit.inputsource.IDtvkitCas;
import org.dtvkit.inputsource.IDtvkitCasCallback;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DtvkitCasService extends Service {
    private static final String TAG = "DtvkitCas";
    private static final String JSONRPC = "jsonrpc";
    private static final String JSONRPC_VER = "2.0";
    private static final String JSONRPC_ID = "id";
    private static final String JSONRPC_METHOD = "method";
    private static final String JSONRPC_PARAMS = "params";
    private static final String JSONRPC_RESULT = "result";
    private static final String JSONRPC_ERROR = "error";
    
    private DtvkitGlueClient mDtvkitGlueClient;
    private final RemoteCallbackList<IDtvkitCasCallback> mCallbacks = new RemoteCallbackList<IDtvkitCasCallback>();

  
    @Override
    public void onCreate() {
        super.onCreate();
        Log.d(TAG, "onCreate()");
        
        new Thread(new Runnable() {
            @Override
            public void run() {
                mDtvkitGlueClient = DtvkitGlueClient.getInstance();
                mDtvkitGlueClient.registerSignalHandler(mHandler);
            }
        }).start();
    }
 
     @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy()");
    }

    @Override
    public IBinder onBind(Intent intent) {

        return new IDtvkitCas.Stub() {

            public String jsonRequest(String json) throws RemoteException {
                Log.d(TAG, "jsonRequest() " + json);

                try {
                    JSONObject request = new JSONObject(json);
                    JSONObject response = new JSONObject();
                    String method = request.getString (JSONRPC_METHOD);
                    int id = request.getInt (JSONRPC_ID);
                    response.put(JSONRPC, JSONRPC_VER);
                    response.put(JSONRPC_ID, id);

                    /*------- \u57fa\u672c\u4fe1\u606f\u67e5\u8be2 -------*/
                    if (false) {
                    
                    } else if (method.equals ("ChangePin")) {
                        changePin(request, response);
                    } else if (method.equals ("DelDetitleChkNum")) {
                        delDetitleChkNum(request, response);
                    } else if (method.equals ("DelEmail")) {
                        delEmail(request, response);
                    } else if (method.equals ("FormatBuffer")) {
                        formatBuffer(request, response);
                    } else if (method.equals ("GetVer")) {
                        getVer(request, response);
                    } else if (method.equals ("GetACList")) {
                        getACList(request, response);
                    } else if (method.equals ("GetCardFreezeStatus")) {
                        getCardFreezeStatus(request, response);
                    } else if (method.equals ("GetCardSN")) {
                        getCardSN(request, response);
                    } else if (method.equals ("GetCardVer")) {
                        getCardVer(request, response);
                    } else if (method.equals ("GetCASystemID")) {
                        getCASystemID(request, response);
                    } else if (method.equals ("GetChipID")) {
                        getChipID(request, response);
                    } else if (method.equals ("GetDetitleChkNums")) {
                        getDetitleChkNums(request, response);
                    } else if (method.equals ("GetDetitleReaded")) {
                        getDetitleReaded(request, response);
                    } else if (method.equals ("GetEmailContent")) {
                        getEmailContent(request, response);
                    } else if (method.equals ("GetEmailHead")) {
                        getEmailHead(request, response);
                    } else if (method.equals ("GetEmailHeads")) {
                        getEmailHeads(request, response);
                    } else if (method.equals ("GetEmailSpaceInfo")) {
                        getEmailSpaceInfo(request, response);
                    } else if (method.equals ("GetEntitleIDs")) {
                        getEntitleIDs(request, response);
                    } else if (method.equals ("GetOperatorIds")) {
                        getOperatorIds(request, response);
                    } else if (method.equals ("GetOperatorInfo")) {
                        getOperatorInfo(request, response);
                    } else if (method.equals ("GetPlatformID")) {
                        getPlatformID(request, response);
                    } else if (method.equals ("GetRating")) {
                        getRating(request, response);
                    } else if (method.equals ("GetServiceEntitles")) {
                        getServiceEntitles(request, response);
                    } else if (method.equals ("GetSlotIDs")) {
                        getSlotIDs(request, response);
                    } else if (method.equals ("GetSlotInfo")) {
                        getSlotInfo(request, response);
                    } else if (method.equals ("GetSTBSN")) {
                        getSTBSN(request, response);
                    } else if (method.equals ("GetTerminalTypeID")) {
                        getTerminalTypeID(request, response);
                    } else if (method.equals ("GetWorkTime")) {
                        getWorkTime(request, response);
                    } else if (method.equals ("IsPaired")) {
                        isPaired(request, response);
                    } else if (method.equals ("RefreshInterface")) {
                        refreshInterface(request, response);
                    } else if (method.equals ("SetRating")) {
                        setRating(request, response);
                    } else if (method.equals ("GetDrmKey")) {
                        getDrmKey(request, response);
                    } else {
                        Log.d("Error", "unknown method: " + method);
                        response.put(JSONRPC_ERROR, "{\"code\": -1, \"message\": \"Method not found\"}");
                    }
                    Log.d(TAG, "response: " + response.toString());
                    return response.toString();
                }catch (JSONException err){
                    Log.d("Error", err.toString());
                    //response.put(JSONRPC_ERROR, "{\"code\": -1, \"message\": \"Method not found\"}");
                }
                
                return null;
            }            

            public void changePin(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "changePin()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    //Log.d(TAG, "changePin() old: " + args.getString(0) + "  new: " + args.getString(1)); 
                    JSONObject ret = mDtvkitGlueClient.request("Cas.changePin", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void delDetitleChkNum(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "delDetitleChkNum()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    boolean ret = mDtvkitGlueClient.request("Cas.delDetitleChkNum", args).getBoolean("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void delEmail(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "delEmail()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.delEmail", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void formatBuffer(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "formatBuffer()");

                try {
                    JSONArray args = new JSONArray();
                    JSONObject ret = mDtvkitGlueClient.request("Cas.formatBuffer", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getACList(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getACList()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getACList", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getCardFreezeStatus(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getCardFreezeStatus()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getCardFreezeStatus", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getCardSN(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getCardSN()");

                String sn = "";
                try {
                    JSONArray args = new JSONArray();
                    sn = mDtvkitGlueClient.request("Cas.getCardSN", args).getString("data");
                    response.put(JSONRPC_RESULT, sn);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getCardVer(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getCardVer()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getCardVer", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getCASystemID(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getCASystemID()");

                //FIXME
                long id = 0x4A02;
                try {
                    response.put(JSONRPC_RESULT, id);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getChipID(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getChipID()");

                long id = 0;
                try {
                    JSONArray args = new JSONArray();
                    String sn = mDtvkitGlueClient.request("Cas.getSTBSN", args).getString("data");
                    id = Long.valueOf(sn).longValue();
                    id &= 0xFFFFFFFFL;
                    response.put(JSONRPC_RESULT, id);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getDetitleChkNums(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getDetitleChkNums()");

                try {
                    JSONArray args = new JSONArray();
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getDetitleChkNums", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getDetitleReaded(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getDetitleReaded()");

                try {
                    JSONArray args = new JSONArray();
                    boolean ret = mDtvkitGlueClient.request("Cas.getDetitleReaded", args).getBoolean("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getEmailContent(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getEmailContent()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getEmailContent", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getEmailHead(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getEmailHead()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getEmailHead", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getEmailHeads(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getEmailHeads()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getEmailHeads", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getEmailSpaceInfo(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getEmailSpaceInfo()");

                try {
                    JSONArray args = new JSONArray();
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getEmailSpaceInfo", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getEntitleIDs(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getEntitleIDs()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getEntitleIDs", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getOperatorIds(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getOperatorIds()");

                try {
                    JSONArray args = new JSONArray();
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getOperatorIds", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getOperatorInfo(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getOperatorIds()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getOperatorInfo", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getPlatformID(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getPlatformID()");

                long id = 0;
                try {
                    JSONArray args = new JSONArray();
                    id = mDtvkitGlueClient.request("Cas.getPlatformID", args).getLong("data");
                    response.put(JSONRPC_RESULT, id);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getRating(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getRating()");

                try {
                    JSONArray args = new JSONArray();
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getRating", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getServiceEntitles(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getServiceEntitles()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getServiceEntitles", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getSlotIDs(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getSlotIDs()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getSlotIDs", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getSlotInfo(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getSlotInfo()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getSlotInfo", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getSTBSN(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getSTBSN()");

                String sn = "";
                try {
                    JSONArray args = new JSONArray();
                    sn = mDtvkitGlueClient.request("Cas.getSTBSN", args).getString("data");
                    response.put(JSONRPC_RESULT, sn);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getTerminalTypeID(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getTerminalTypeID()");

                long id = 0;
                try {
                    JSONArray args = new JSONArray();
                    id = mDtvkitGlueClient.request("Cas.getTerminalTypeID", args).getLong("data");
                    response.put(JSONRPC_RESULT, id);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getVer(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getVer()");

                long ver = 0;
                try {
                    JSONArray args = new JSONArray();
                    ver = mDtvkitGlueClient.request("Cas.getVer", args).getLong("data");
                    response.put(JSONRPC_RESULT, ver);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getWorkTime(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getWorkTime()");

                try {
                    JSONArray args = new JSONArray();
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getWorkTime", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void isPaired(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "isPaired()");

                try {
                    JSONArray args = new JSONArray();
                    JSONObject ret = mDtvkitGlueClient.request("Cas.isPaired", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void setRating(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "setRating()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.setRating", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void getDrmKey(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "getDrmKey()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    JSONObject ret = mDtvkitGlueClient.request("Cas.getDrmKey", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

            public void refreshInterface(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "refreshInterface()");

                try {
                    JSONArray args = new JSONArray();
                    JSONObject ret = mDtvkitGlueClient.request("Cas.refreshInterface", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }

// ========================================================================================================================
            public String getCardSN() throws RemoteException {
                Log.d(TAG, "getCardSN()");

                String sn = "";
                try {
                    JSONArray args = new JSONArray();
                    sn = mDtvkitGlueClient.request("Cas.getCardSN", args).getString("data");
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
                return sn;
            }

            public String getSTBSN() throws RemoteException {
                Log.d(TAG, "getSTBSN()");

                String sn = "";
                try {
                    JSONArray args = new JSONArray();
                    sn = mDtvkitGlueClient.request("Cas.getSTBSN", args).getString("data");
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
                return sn;
            }
            
            public void registerCallback(IDtvkitCasCallback cb) {
            Log.d(TAG, "registerCallback()");
                if (cb != null) mCallbacks.register(cb);
            }
            
            public void unregisterCallback(IDtvkitCasCallback cb) {
                Log.d(TAG, "unregisterCallback()");
                if (cb != null) mCallbacks.unregister(cb);
            }
        };
    }

    private final DtvkitGlueClient.SignalHandler mHandler = new DtvkitGlueClient.SignalHandler() {
        @Override
        public void onSignal(String signal, JSONObject data) {
            if (! signal.substring(0,3).equals("Cas"))
                return;

            try {
                String method = signal.substring(3);
                JSONArray params = data.getJSONArray("params");
                JSONObject request = new JSONObject();
                request.put("jsonrpc", "2.0");
                request.put("id", 0);
                request.put("method", method);
                request.put("params", params);
            
                Log.d(TAG, "onSignal: " + request.toString());
                int i = mCallbacks.beginBroadcast();
                while (i > 0) {
                    i--;
                    mCallbacks.getBroadcastItem(i).request(request.toString());
                    // The RemoteCallbackList will take care of removing
                    // the dead object for us.
                }
                mCallbacks.finishBroadcast();
            }
            catch (Exception e) {
                Log.e(TAG, e.getMessage());
            }
        }
    };
}
