package org.dtvkit.inputsource;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.IBinder;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Log;

import java.lang.Long;

import org.dtvkit.inputsource.IDtvkitDvb;
import org.dtvkit.inputsource.IDtvkitDvbCallback;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DtvkitDvbService extends Service {
    private static final String TAG = "DtvkitDvb";
    private static final String JSONRPC = "jsonrpc";
    private static final String JSONRPC_VER = "2.0";
    private static final String JSONRPC_ID = "id";
    private static final String JSONRPC_METHOD = "method";
    private static final String JSONRPC_PARAMS = "params";
    private static final String JSONRPC_RESULT = "result";
    private static final String JSONRPC_ERROR = "error";
    private static final String CHANNEL_ID = "DtvkitDvbServiceChannel";
    
    private DtvkitGlueClient mDtvkitGlueClient;
    private final RemoteCallbackList<IDtvkitDvbCallback> mCallbacks = new RemoteCallbackList<IDtvkitDvbCallback>();

  
    @Override
    public void onCreate() {
        super.onCreate();
        Log.d(TAG, "onCreate");
        startMyOwnForeground();
        
        new Thread(new Runnable() {
            @Override
            public void run() {
                mDtvkitGlueClient = DtvkitGlueClient.getInstance();
                mDtvkitGlueClient.registerSignalHandler(mHandler);
            }
        }).start();
    }
 
     @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy");
    }

	@Override
	public int onStartCommand(Intent intent, int flags, int startId) {
        Log.i(TAG, "onStartCommand");


		return super.onStartCommand(intent, flags, startId);
	}

    private void startMyOwnForeground(){
        Log.i(TAG, "startMyOwnForeground");
        String NOTIFICATION_CHANNEL_ID = "org.dtvkit.inputsource.dvb";
        String channelName = "My Foreground Service";
        NotificationChannel chan = new NotificationChannel(NOTIFICATION_CHANNEL_ID, channelName, NotificationManager.IMPORTANCE_NONE);
        chan.setLightColor(Color.BLUE);
        chan.setLockscreenVisibility(Notification.VISIBILITY_PRIVATE);
        NotificationManager manager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        assert manager != null;
        manager.createNotificationChannel(chan);

        Notification.Builder notificationBuilder = new Notification.Builder(this, NOTIFICATION_CHANNEL_ID);
        Notification notification = notificationBuilder.setOngoing(true)
                .setSmallIcon(R.drawable.dtvkit)
                .setContentTitle("Dtvkit DVB service is running")
                .setPriority(NotificationManager.IMPORTANCE_MIN)
                .setCategory(Notification.CATEGORY_SERVICE)
                .build();
        startForeground(2, notification);
    }

    @Override
    public IBinder onBind(Intent intent) {

        return new IDtvkitDvb.Stub() {

            public String jsonRequest(String json) throws RemoteException {
                Log.d(TAG, "jsonRequest() " + json);

                try {
                    JSONObject request = new JSONObject(json);
                    JSONObject response = new JSONObject();
                    String method = request.getString (JSONRPC_METHOD);
                    int id = request.getInt (JSONRPC_ID);
                    response.put(JSONRPC, JSONRPC_VER);
                    response.put(JSONRPC_ID, id);

                    /*------- \u57fa\u672c\u4fe1\u606f\u67e5\u8be2 -------*/
                    if (false) {
                    
                    } else if (method.equals ("ChangePin")) {
                        changePin(request, response);
                    } else {
                        Log.d("Error", "unknown method: " + method);
                        response.put(JSONRPC_ERROR, "{\"code\": -1, \"message\": \"Method not found\"}");
                    }
					Log.d(TAG, "response: " + response.toString());
                    return response.toString();
                }catch (JSONException err){
                    Log.d("Error", err.toString());
                    //response.put(JSONRPC_ERROR, "{\"code\": -1, \"message\": \"Method not found\"}");
                }
                
                return null;
            }            

            public void changePin(JSONObject request, JSONObject response) throws RemoteException {
                Log.d(TAG, "changePin()");

                try {
                    JSONArray args = request.getJSONArray(JSONRPC_PARAMS);
                    //Log.d(TAG, "changePin() old: " + args.getString(0) + "  new: " + args.getString(1)); 
                    JSONObject ret = mDtvkitGlueClient.request("Dvb.changePin", args).getJSONObject("data");
                    response.put(JSONRPC_RESULT, ret);
                }
                catch (Exception e) {
                    Log.e(TAG, e.getMessage());
                }
            }
            
            public void registerCallback(IDtvkitDvbCallback cb) {
            Log.d(TAG, "registerCallback()");
                if (cb != null) mCallbacks.register(cb);
            }
            
            public void unregisterCallback(IDtvkitDvbCallback cb) {
                Log.d(TAG, "unregisterCallback()");
                if (cb != null) mCallbacks.unregister(cb);
            }
        };
    }

    private final DtvkitGlueClient.SignalHandler mHandler = new DtvkitGlueClient.SignalHandler() {
        @Override
        public void onSignal(String signal, JSONObject data) {
            if (! signal.substring(0,3).equals("Cas"))
                return;

            try {
                String method = signal.substring(3);
                JSONArray params = data.getJSONArray("params");
                JSONObject request = new JSONObject();
                   request.put("jsonrpc", "2.0");
                   request.put("id", 0);
                   request.put("method", method);
                   request.put("params", params);
            
                Log.d(TAG, "onSignal: " + request.toString());
                int i = mCallbacks.beginBroadcast();
                while (i > 0) {
                    i--;
                    mCallbacks.getBroadcastItem(i).request(request.toString());
                    // The RemoteCallbackList will take care of removing
                    // the dead object for us.
                }
                mCallbacks.finishBroadcast();
            }
            catch (Exception e) {
                Log.e(TAG, e.getMessage());
            }
        }
    };
}
