package org.dtvkit.inputsource;

import android.app.Activity;
import android.app.Instrumentation;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.KeyEvent;
import android.view.Gravity;
import android.view.View;
import android.text.InputType;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;

import org.dtvkit.inputsource.DtvkitGlueClient;
import org.dtvkit.inputsource.R;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.tv.TvContract;
import android.media.tv.TvInputInfo;
import android.support.v4.content.LocalBroadcastManager;
import android.widget.Spinner;
import android.widget.TextView;

import java.util.Locale;

import org.dtvkit.companionlibrary.EpgSyncJobService;
import org.dtvkit.companionlibrary.model.Channel;
import org.dtvkit.companionlibrary.utils.TvContractUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import android.support.v7.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;


public class HomeplusSearchChannel extends AppCompatActivity {
    private String TAG = "HomeplusSearchChannel";
    private static boolean DEBUG = true;

    private ConstraintLayout clSetup, clProgress;
    private TextView tvQamTick, tvQamValue, tvBID;
    private EditText etFrequency,etSR;
    private Button btnQAM, btnNext, btnConfirm;
    private String[] qamItems;
    private boolean networkScan;
    private int qamIndex = 4; //256
    int qamValueCurrent = 256;

    private LinearLayout llSearching, llResult;
    private TextView tvFrequency, tvSR, tvQamValue2, tvBID2;
    private ProgressBar pbSNR, pbStrength;
    private TextView tvVideoServices, tvAudioServices, tvOtherServices;
    private TextView tvSNR, tvStrength;
    private int iBouquetId = 25149;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.homeplus_channel_base);

	clSetup =  (ConstraintLayout) findViewById(R.id.homeplus_channel_search_setup);
	clProgress =  (ConstraintLayout) findViewById(R.id.homeplus_channel_search_progress);
	qamIndex = 4;
        initLayout();
        networkScan = true;
	iBouquetId = getBouquetId();
	Log.d(TAG, "iBouquetId: " + iBouquetId);
	tvBID.setText("" + iBouquetId);
        updateDefaultLanguage();
    }

    private void initLayout() {
        etFrequency = (EditText) findViewById(R.id.etFrequency);
        etSR = (EditText) findViewById(R.id.etSR);
        btnQAM = (Button) findViewById(R.id.btnQAM);
        btnNext = (Button) findViewById(R.id.btnNext);
        btnConfirm = (Button) findViewById(R.id.btnConfirm);
	tvQamTick = (TextView) findViewById(R.id.tvQamTick);
	tvQamValue = (TextView) findViewById(R.id.tvQamValue);
	tvBID = (TextView) findViewById(R.id.tvBID);

	//homeplus_channel_search_progress
	llSearching = (LinearLayout) findViewById(R.id.llSearching);
	llResult = (LinearLayout) findViewById(R.id.llResult);
	tvFrequency = (TextView) findViewById(R.id.tvFrequency);
	tvSR = (TextView) findViewById(R.id.tvSR);
	tvQamValue2 = (TextView) findViewById(R.id.tvQamValue2);
	tvBID2 = (TextView) findViewById(R.id.tvBID2);
        pbSNR = (ProgressBar) findViewById(R.id.pbSNR);
        pbStrength = (ProgressBar) findViewById(R.id.pbStrength);
	tvVideoServices = (TextView) findViewById(R.id.tvVideoServices);
	tvAudioServices = (TextView) findViewById(R.id.tvAudioServices);
	tvOtherServices = (TextView) findViewById(R.id.tvOtherServices);
	tvSNR = (TextView) findViewById(R.id.tvSNR);
	tvStrength = (TextView) findViewById(R.id.tvStrength);

        qamItems = getResources().getStringArray(R.array.qam_list);

	etFrequency.setInputType(InputType.TYPE_NULL);
        etFrequency.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etFrequency.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

	etSR.setInputType(InputType.TYPE_NULL);
        etSR.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etSR.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        btnQAM.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                } else {
		    //redraw to show the current QAM setting
		    int qval = Integer.parseInt(tvQamValue.getText().toString());
		    if (qval != qamValueCurrent) {
			//find current qam index
			for (int i=0; i < qamItems.length; i++) {
			    if (Integer.parseInt(qamItems[i]) == qamValueCurrent) {
				qamIndex = i;
				break;
			    }
			}
			Log.d(TAG, "recovery QAM show text to " + qamItems[qamIndex]);
			tvQamValue.setText(qamItems[qamIndex]);
			tvQamTick.setVisibility(View.VISIBLE);
		    }
                }
            }

        });

        btnQAM.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			qamValueCurrent = Integer.parseInt(qamItems[qamIndex]);
			Log.d(TAG, "qamValueCurrent set to " + qamValueCurrent);
			tvQamTick.setVisibility(View.VISIBLE);

                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
                        nextResolution(keyCode);
                        return true;
                    }
                }
                return false;
            }
        });

        btnNext.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                    } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			//check parameters
			if (etFrequency.getText().toString().equals("") ||
			    etSR.getText().toString().equals("")) {
			    String msg = "搜尋參數錯誤";
			    Toast toast = Toast.makeText(HomeplusSearchChannel.this, msg, Toast.LENGTH_SHORT);
			    toast.setGravity(Gravity.CENTER, 0, 0);
			    toast.show();

			    return true;
			}

			//assign value from setup
			tvFrequency.setText(etFrequency.getText().toString());
			tvSR.setText(etSR.getText().toString());
			tvQamValue2.setText("QAM" + qamValueCurrent);
			tvBID2.setText(tvBID.getText().toString());

			//change layout
			btnConfirm.setEnabled(false);
			clProgress.setVisibility(View.VISIBLE);
			clSetup.setVisibility(View.INVISIBLE);

			startSearch();
			return true;
                    }
                }
                return false;
            }
        });

        btnConfirm.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			//return code
			setResult(RESULT_OK, getIntent());

			//finish
			HomeplusSearchChannel.this.finish();
			return true;

                    }
                }
                return false;
            }
        });
    }

    private void nextResolution(int keyCode) {
        if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
            qamIndex = qamIndex - 1;
            if (qamIndex == -1) {
                qamIndex = qamItems.length - 1;
            }
        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
            qamIndex = qamIndex + 1;
            if (qamIndex == qamItems.length) {
                qamIndex = 0;
            }
        } else {

        }

	if (qamValueCurrent == Integer.parseInt(qamItems[qamIndex])) {
	    tvQamTick.setVisibility(View.VISIBLE);
	} else {
	    tvQamTick.setVisibility(View.INVISIBLE);
	}
        tvQamValue.setText(qamItems[qamIndex]);
    }

    private void showSettingsRight(int index) {
        switch (index) {
            case 0:
                break;
            case 1:
                break;
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
	    //FIXME - not allow back?
	    setResult(1, getIntent());
            finish();
        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        if (DEBUG) Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        if (DEBUG) Log.d(TAG, "onPause");
        super.onPause();
    }

    @Override
    public void onDestroy() {
        if (DEBUG) Log.d(TAG, "onDestroy");
        super.onDestroy();
        stopMonitoringSearch();
        stopMonitoringSync();
    }

    private Handler mHandler2 = new Handler() {
	public void handleMessage(Message msg) {
	    super.handleMessage(msg);
	    int signalNoiseRatio = msg.getData().getInt("SNR");
	    int signalStrength = msg.getData().getInt("STRENGTH");

	    tvSNR.setText(Integer.toString(signalNoiseRatio));
	    pbSNR.setProgress(signalNoiseRatio);
	    tvStrength.setText(Integer.toString(signalStrength));
	    pbStrength.setProgress(signalStrength);
	}
    };
    // =============================================================================
    private final DtvkitGlueClient.SignalHandler mHandler = new DtvkitGlueClient.SignalHandler() {
        @Override
        public void onSignal(String signal, JSONObject data) {
            if (signal.equals("DvbcStatusChanged")) {
		Log.d(TAG, "DvbcStatusChanged");
                int progress = 0;
                int bitErrorRate = 10000000;
                int signalNoiseRatio = 0;
                int signalStrength = 0;
                try {
                    progress = data.getInt("progress");
                    if (progress > 100)
                        progress = 100;

                    bitErrorRate = data.getInt("bit-error-rate");
                    signalNoiseRatio = data.getInt("signal-noise-ratio");
                    signalStrength = data.getInt("signal-strength");
                } catch (JSONException ignore) {
		    Log.d(TAG, "Error: " + ignore.toString());
                }

		Log.d(TAG, "[" + progress + "%] SNR: " + signalNoiseRatio + ", Strength: " + signalStrength);
		Bundle bundle = new Bundle();
                bundle.putInt("SNR", signalNoiseRatio);
                bundle.putInt("STRENGTH", signalStrength);
                Message msg = new Message();
                msg.setData(bundle);
                mHandler2.sendMessage(msg);

                if (progress == 100) {
                    onSearchFinished();
                }
            }
        }
    };

    private final BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, final Intent intent) {
            String status = intent.getStringExtra(EpgSyncJobService.SYNC_STATUS);
            if (status.equals(EpgSyncJobService.SYNC_FINISHED)) {
                // reset
                pbSNR.setProgress(0);
                pbStrength.setProgress(0);

                int numberOfServices = 0;
                int videoServices = 0;
                int audioServices = 0;
                int otherServices = 0;
                String inputId = TvContract.buildInputId(new ComponentName(context, DtvkitTvInput.class));
                LongSparseArray<Channel> channelMap = 
                    TvContractUtils.buildChannelMap(context.getContentResolver(), inputId);
                if (null != channelMap) {
                    numberOfServices = channelMap.size();
                    for(int i = 0;  i < numberOfServices; i++) {
                        Channel channel = channelMap.valueAt(i);
                        if (null != channel) {
                            String serviceType = channel.getServiceType();
                            if (TvContract.Channels.SERVICE_TYPE_AUDIO_VIDEO.equals(serviceType)) {
                                videoServices ++;
                            }
                            else if (TvContract.Channels.SERVICE_TYPE_AUDIO.equals(serviceType)) {
                                audioServices ++;
                            }
                            else if (TvContract.Channels.SERVICE_TYPE_OTHER.equals(serviceType)) {
                                otherServices ++;
                            }
                        }
                    }
                }          

		//show the result on UI
		Log.d(TAG, "scanResult: [" + videoServices + ", " + audioServices + ", " + otherServices + "]");
		tvVideoServices.setText(Integer.toString(videoServices));
		tvAudioServices.setText(Integer.toString(audioServices));
		tvOtherServices.setText(Integer.toString(otherServices));
		llSearching.setVisibility(View.GONE);
		llResult.setVisibility(View.VISIBLE);
		btnConfirm.setEnabled(true);
            }
        }
    };

    private void startSearch() {
        startMonitoringSearch();
        //FIXME: for the CNS POC only
        SystemProperties.set("persist.vendor.dvb.netscan", (networkScan==true)?"1":"0");
        try {
            JSONArray args = new JSONArray();
            Integer frequencyHz = Integer.parseInt(etFrequency.getText().toString() + String.valueOf("000"));

            args.put(networkScan);
            args.put(frequencyHz);
            args.put(String.valueOf("qam") + qamValueCurrent);
            args.put(Integer.parseInt(etSR.getText().toString()));
            args.put(true); // retune
            args.put(frequencyHz);
            args.put(String.valueOf("6MHz"));
            args.put(getBouquetId());

            if (DEBUG) Log.i(TAG, args.toString());

            DtvkitGlueClient.getInstance().request("Dvbc.startManualSearch", args);
        } catch (Exception e) {
	    Log.d(TAG, "Error: scan not start - " + e.toString());
            stopMonitoringSearch();
        }
    }

    private void onSearchFinished() {
	Log.d(TAG, "onSearchFinished");
        stopMonitoringSearch();
        try {
            JSONArray args = new JSONArray();
            args.put(true); // Commit
            DtvkitGlueClient.getInstance().request("Dvbc.finishSearch", args);
        } catch (Exception e) {
            stopMonitoringSearch();
            return;
        }

        startMonitoringSync();
        // By default, gets all channels and 1 hour of programs (DEFAULT_IMMEDIATE_EPG_DURATION_MILLIS)
        EpgSyncJobService.cancelAllSyncRequests(this);

        // If the intent that started this activity is from Live Channels app
        //String inputId = this.getIntent().getStringExtra(TvInputInfo.EXTRA_INPUT_ID);
        String inputId = TvContract.buildInputId(new ComponentName(getApplicationContext(), DtvkitTvInput.class));
        Log.i(TAG, String.format("inputId: %s", inputId));
        EpgSyncJobService.requestImmediateSync(this, inputId,
                EpgSyncJobService.SYNC_MODE_NOW_NEXT, true,
                new ComponentName(this, DtvkitEpgSync.class));
    }

    private void startMonitoringSearch() {
        DtvkitGlueClient.getInstance().registerSignalHandler(mHandler);
    }

    private void stopMonitoringSearch() {
        DtvkitGlueClient.getInstance().unregisterSignalHandler(mHandler);
    }

    private void startMonitoringSync() {
        LocalBroadcastManager.getInstance(this).registerReceiver(mReceiver,
                new IntentFilter(EpgSyncJobService.ACTION_SYNC_STATUS_CHANGED));
    }

    private void stopMonitoringSync() {
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mReceiver);
    }

   private String playerGetDefaultSubtitlesLanguageCode()
   {
      String code = "";
      JSONArray args = new JSONArray();
      try
      {
         code =
            DtvkitGlueClient.getInstance().request("Player.getDefaultSubtitlesLanguage", args)
               .getJSONObject("data").getString("code");
      }
      catch (Exception e)
      {
         Log.e(TAG, e.getMessage());
      }

      return code;
   }

   private boolean playerSetDefaultSubtitlesLanguage(String code)
   {
      boolean success = false;
      JSONArray args = new JSONArray();
      args.put(code);
      try
      {
         success =
            DtvkitGlueClient.getInstance().request("Player.setDefaultSubtitlesLanguage", args)
               .getBoolean("data");
      }
      catch (Exception e)
      {
         Log.e(TAG, e.getMessage());
      }

      return success;
   }

   private void updateDefaultLanguage()
   {
      String langCode = Locale.getDefault().getISO3Language();
      String defaultSubtitlesLangCode = playerGetDefaultSubtitlesLanguageCode();
      Log.d(TAG, "System lang code: " + langCode);

       if ("zho".equals(langCode)) {
          langCode = "chi";
       }

      if (playerSetDefaultSubtitlesLanguage(langCode))
      {
         Log.d(TAG, "Default subtitles language changed from " + defaultSubtitlesLangCode +
            " to " + langCode);
      }
   }

   private int getBouquetId() {
       Log.d(TAG, "getBouquetId()");
       int bouquetId = 25149;

       String sBouquetId = SystemProperties.get("persist.vendor.dvb.bid");
       if ((sBouquetId != null) && (!sBouquetId.equals(""))) {
	    return Integer.parseInt(sBouquetId);
       }

       DtvkitGlueClient mDtvkitGlueClient = DtvkitGlueClient.getInstance();
       try {
           JSONArray args = new JSONArray();
           JSONObject ret = mDtvkitGlueClient.request("Cas.getOperatorIds", args).getJSONObject("data");
           JSONArray tvsidArray = ret.getJSONObject("data").getJSONArray ("tvsid");
           
           for (int i = 0, size = tvsidArray.length(); i < size; i++) {
               int tvsid = tvsidArray.getInt(i);
               if (0 != tvsid) {
                   args = new JSONArray();
                   args.put(tvsid);
                   JSONObject ret2 = mDtvkitGlueClient.request("Cas.getACList", args).getJSONObject("data");
                   JSONArray acArray = ret2.getJSONObject("data").getJSONArray ("ac_array");
                   long bid = acArray.getLong(1);
                   bid &= 0xFFFF;
                   if (0 != bid) {
                       bouquetId = (int)bid;
                       Log.d(TAG, "operator ID: " + tvsid + " bouquet iD: " + bouquetId);
                       break;
                   }
               }
           }
       } catch (Exception e) {
           Log.e(TAG, e.getMessage());
       }
       
       return bouquetId;
   }
}
