package org.dtvkit.inputsource;

import android.app.Activity;
import android.app.Instrumentation;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemProperties;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.KeyEvent;
import android.view.Gravity;
import android.view.View;
import android.text.InputType;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;

import org.dtvkit.inputsource.DtvkitGlueClient;
import org.dtvkit.inputsource.R;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.tv.TvContract;
import android.media.tv.TvInputInfo;
import android.support.v4.content.LocalBroadcastManager;
import android.widget.Spinner;
import android.widget.TextView;

import java.util.Locale;

import org.dtvkit.companionlibrary.EpgSyncJobService;
import org.dtvkit.companionlibrary.model.Channel;
import org.dtvkit.companionlibrary.utils.TvContractUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import android.support.v7.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;

import android.app.AlertDialog;
import android.content.DialogInterface;


public class HomeplusSearchChannelAll extends AppCompatActivity {
    private String TAG = "HomeplusSearchChannelAll";
    private static boolean DEBUG = true;

    private TextView tvTitle, tvSubtitle;
    private TextView tvQamTick, tvQamValue, tvBIDTitle, tvBID;
    private EditText etFrequency,etSR;
    private Button btnQAM, btnSearch, btnCancel;
    private String[] qamItems;
    private boolean networkScan;
    private int qamIndex = 4; //256
    int qamValueCurrent = 256;
    private TextView tvBer, tvSNR, tvStrength, tvProgress;
    private ProgressBar pbSNR, pbStrength, pbProgress;
    private int iBouquetId = 25149;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.homeplus_channel_scan_all);

	Bundle bundle = getIntent().getExtras();
	qamIndex = 4;
        initLayout();
	networkScan = true;
	iBouquetId = getBouquetId();
	Log.d(TAG, "iBouquetId: " + iBouquetId);
	tvBID.setText("" + iBouquetId);
	if (bundle != null) {
	    int netscan = bundle.getInt("NETSCAN");
	    if (netscan == 0) {
		networkScan = false;
		tvTitle.setText("搜尋頻道 > 單一頻段掃描");
		tvBIDTitle.setVisibility(View.GONE);
		tvBID.setVisibility(View.GONE);
	    }
	}
	Log.d(TAG, "networkScan: " + networkScan);
        updateDefaultLanguage();
    }

    private void initLayout() {
	tvTitle = (TextView) findViewById(R.id.tvTitle);
	tvSubtitle = (TextView) findViewById(R.id.tvSubtitle);
        etFrequency = (EditText) findViewById(R.id.etFrequency);
        etSR = (EditText) findViewById(R.id.etSR);
        btnQAM = (Button) findViewById(R.id.btnQAM);
        btnSearch = (Button) findViewById(R.id.btnSearch);
        btnCancel = (Button) findViewById(R.id.btnCancel);
	tvQamTick = (TextView) findViewById(R.id.tvQamTick);
	tvQamValue = (TextView) findViewById(R.id.tvQamValue);
	tvBIDTitle = (TextView) findViewById(R.id.tvBIDTitle);
	tvBID = (TextView) findViewById(R.id.tvBID);
	tvBer = (TextView) findViewById(R.id.tvBer);
	tvSNR = (TextView) findViewById(R.id.tvSNR);
	tvStrength = (TextView) findViewById(R.id.tvStrength);
	tvProgress = (TextView) findViewById(R.id.tvProgress);
        pbSNR = (ProgressBar) findViewById(R.id.pbSNR);
        pbStrength = (ProgressBar) findViewById(R.id.pbStrength);
        pbProgress = (ProgressBar) findViewById(R.id.pbProgress);

        qamItems = getResources().getStringArray(R.array.qam_list);

	etFrequency.setInputType(InputType.TYPE_NULL);
        etFrequency.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etFrequency.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

	etSR.setInputType(InputType.TYPE_NULL);
        etSR.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etSR.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        btnQAM.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                } else {
		    //redraw to show the current QAM setting
		    int qval = Integer.parseInt(tvQamValue.getText().toString());
		    if (qval != qamValueCurrent) {
			//find current qam index
			for (int i=0; i < qamItems.length; i++) {
			    if (Integer.parseInt(qamItems[i]) == qamValueCurrent) {
				qamIndex = i;
				break;
			    }
			}
			Log.d(TAG, "recovery QAM show text to " + qamItems[qamIndex]);
			tvQamValue.setText(qamItems[qamIndex]);
			tvQamTick.setVisibility(View.VISIBLE);
		    }
                }
            }

        });

        btnQAM.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			qamValueCurrent = Integer.parseInt(qamItems[qamIndex]);
			Log.d(TAG, "qamValueCurrent set to " + qamValueCurrent);
			tvQamTick.setVisibility(View.VISIBLE);

                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_DOWN) {
			btnSearch.requestFocus();
                        return true;
                    }
                }
                return false;
            }
        });

        btnSearch.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                    } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			//check parameters
			if (etFrequency.getText().toString().equals("") ||
			    etSR.getText().toString().equals("")) {
			    String msg = "搜尋參數錯誤";
			    Toast toast = Toast.makeText(HomeplusSearchChannelAll.this, msg, Toast.LENGTH_SHORT);
			    toast.setGravity(Gravity.CENTER, 0, 0);
			    toast.show();

			    return true;
			}

			//change layout
			tvSubtitle.setText("搜尋中...");
			tvProgress.setText("" + 0);
			pbProgress.setProgress(0);
			btnCancel.setEnabled(false);

			startSearch();
			return true;
                    }
                }
                return false;
            }
        });

        btnCancel.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			//return code
			setResult(RESULT_OK, getIntent());

			//finish
			HomeplusSearchChannelAll.this.finish();
			return true;

                    }
                }
                return false;
            }
        });
    }

    private void nextResolution(int keyCode) {
        if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
            qamIndex = qamIndex - 1;
            if (qamIndex == -1) {
                qamIndex = qamItems.length - 1;
            }
        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
            qamIndex = qamIndex + 1;
            if (qamIndex == qamItems.length) {
                qamIndex = 0;
            }
        } else {

        }

	if (qamValueCurrent == Integer.parseInt(qamItems[qamIndex])) {
	    tvQamTick.setVisibility(View.VISIBLE);
	} else {
	    tvQamTick.setVisibility(View.INVISIBLE);
	}
        tvQamValue.setText(qamItems[qamIndex]);
    }

    private int redKeyTimes = 0;
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
	    //FIXME - not allow back?
	    setResult(1, getIntent());
            finish();
        } else if (keyCode == KeyEvent.KEYCODE_F9) {
	    redKeyTimes ++;
	    if (redKeyTimes == 5) {
		redKeyTimes = 0;
		modifyBouquetId();
		return true;
	    }
	    return true;
        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        if (DEBUG) Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        if (DEBUG) Log.d(TAG, "onPause");
        super.onPause();
    }

    @Override
    public void onDestroy() {
        if (DEBUG) Log.d(TAG, "onDestroy");
        super.onDestroy();
        stopMonitoringSearch();
        stopMonitoringSync();
    }

    private Handler mHandler2 = new Handler() {
	public void handleMessage(Message msg) {
	    super.handleMessage(msg);
	    int bitErrorRate = msg.getData().getInt("BER");
	    int signalNoiseRatio = msg.getData().getInt("SNR");
	    int signalStrength = msg.getData().getInt("STRENGTH");
	    int progress = msg.getData().getInt("PROGRESS");

	    Log.d(TAG, "handle [" + progress + "%] BER: " + bitErrorRate + ", SNR: " + signalNoiseRatio + ", Strength: " + signalStrength);
	    if (bitErrorRate == 0)
		tvBer.setText(String.valueOf(bitErrorRate));
	    else
		tvBer.setText(String.format(Locale.ENGLISH, "%dE-7", bitErrorRate));
	    tvSNR.setText(Integer.toString(signalNoiseRatio));
	    pbSNR.setProgress(signalNoiseRatio);
	    tvStrength.setText(Integer.toString(signalStrength));
	    pbStrength.setProgress(signalStrength);
	    tvProgress.setText(Integer.toString(progress));
	    pbProgress.setProgress(progress);
	}
    };
    // =============================================================================
    private final DtvkitGlueClient.SignalHandler mHandler = new DtvkitGlueClient.SignalHandler() {
        @Override
        public void onSignal(String signal, JSONObject data) {
            if (signal.equals("DvbcStatusChanged")) {
		Log.d(TAG, "DvbcStatusChanged");
                int progress = 0;
                int bitErrorRate = 10000000;
                int signalNoiseRatio = 0;
                int signalStrength = 0;
                try {
                    progress = data.getInt("progress");
                    if (progress > 100)
                        progress = 100;

                    bitErrorRate = data.getInt("bit-error-rate");
                    signalNoiseRatio = data.getInt("signal-noise-ratio");
                    signalStrength = data.getInt("signal-strength");
                } catch (JSONException ignore) {
		    Log.d(TAG, "Error: " + ignore.toString());
                }

		Log.d(TAG, "[" + progress + "%] BER: " + bitErrorRate + ", SNR: " + signalNoiseRatio + ", Strength: " + signalStrength);
		Bundle bundle = new Bundle();
                bundle.putInt("BER", bitErrorRate);
                bundle.putInt("SNR", signalNoiseRatio);
                bundle.putInt("STRENGTH", signalStrength);
                bundle.putInt("PROGRESS", progress);
                Message msg = new Message();
                msg.setData(bundle);
                mHandler2.sendMessage(msg);

                if (progress == 100) {
                    onSearchFinished();
                }
            }
        }
    };

    private final BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, final Intent intent) {
            String status = intent.getStringExtra(EpgSyncJobService.SYNC_STATUS);
            if (status.equals(EpgSyncJobService.SYNC_FINISHED)) {
                // reset
                pbSNR.setProgress(0);
                pbStrength.setProgress(0);

                int numberOfServices = 0;
                int videoServices = 0;
                int audioServices = 0;
                int otherServices = 0;
                String inputId = TvContract.buildInputId(new ComponentName(context, DtvkitTvInput.class));
                LongSparseArray<Channel> channelMap = 
                    TvContractUtils.buildChannelMap(context.getContentResolver(), inputId);
                if (null != channelMap) {
                    numberOfServices = channelMap.size();
                    for(int i = 0;  i < numberOfServices; i++) {
                        Channel channel = channelMap.valueAt(i);
                        if (null != channel) {
                            String serviceType = channel.getServiceType();
                            if (TvContract.Channels.SERVICE_TYPE_AUDIO_VIDEO.equals(serviceType)) {
                                videoServices ++;
                            }
                            else if (TvContract.Channels.SERVICE_TYPE_AUDIO.equals(serviceType)) {
                                audioServices ++;
                            }
                            else if (TvContract.Channels.SERVICE_TYPE_OTHER.equals(serviceType)) {
                                otherServices ++;
                            }
                        }
                    }
                }          

		//show the result on UI
		Log.d(TAG, "scanResult: [" + videoServices + ", " + audioServices + ", " + otherServices + "]");
                String scanResult = getResources().getString(R.string.searched);
                scanResult += String.valueOf("!  ");
                scanResult += getResources().getString(R.string.tv);
                scanResult += String.valueOf(": ");
                scanResult += String.valueOf(videoServices);
                scanResult += String.valueOf(", ");
                scanResult += getResources().getString(R.string.radio);
                scanResult += String.valueOf(": ");
                scanResult += String.valueOf(audioServices);
                scanResult += String.valueOf(", ");
                scanResult += getResources().getString(R.string.data);
                scanResult += String.valueOf(": ");
                scanResult += String.valueOf(otherServices);
                tvSubtitle.setText(scanResult);
		btnCancel.setEnabled(true);
            }
        }
    };

    private void startSearch() {
        startMonitoringSearch();
        //FIXME: for the CNS POC only
        SystemProperties.set("persist.vendor.dvb.netscan", (networkScan==true)?"1":"0");
        try {
            JSONArray args = new JSONArray();
            Integer frequencyHz = Integer.parseInt(etFrequency.getText().toString() + String.valueOf("000"));

            args.put(networkScan);
            args.put(frequencyHz);
            args.put(String.valueOf("qam") + qamValueCurrent);
            args.put(Integer.parseInt(etSR.getText().toString()));
            args.put(true); // retune
            args.put(frequencyHz);
            args.put(String.valueOf("6MHz"));
            args.put(getBouquetId());

            if (DEBUG) Log.i(TAG, args.toString());

            DtvkitGlueClient.getInstance().request("Dvbc.startManualSearch", args);
        } catch (Exception e) {
	    Log.d(TAG, "Error: scan not start - " + e.toString());
            stopMonitoringSearch();
        }
    }

    private void onSearchFinished() {
	Log.d(TAG, "onSearchFinished");
        stopMonitoringSearch();
        try {
            JSONArray args = new JSONArray();
            args.put(true); // Commit
            DtvkitGlueClient.getInstance().request("Dvbc.finishSearch", args);
        } catch (Exception e) {
            stopMonitoringSearch();
            return;
        }

        startMonitoringSync();
        // By default, gets all channels and 1 hour of programs (DEFAULT_IMMEDIATE_EPG_DURATION_MILLIS)
        EpgSyncJobService.cancelAllSyncRequests(this);

        // If the intent that started this activity is from Live Channels app
        //String inputId = this.getIntent().getStringExtra(TvInputInfo.EXTRA_INPUT_ID);
        String inputId = TvContract.buildInputId(new ComponentName(getApplicationContext(), DtvkitTvInput.class));
        Log.i(TAG, String.format("inputId: %s", inputId));
        EpgSyncJobService.requestImmediateSync(this, inputId,
                EpgSyncJobService.SYNC_MODE_NOW_NEXT, true,
                new ComponentName(this, DtvkitEpgSync.class));
    }

    private void startMonitoringSearch() {
        DtvkitGlueClient.getInstance().registerSignalHandler(mHandler);
    }

    private void stopMonitoringSearch() {
        DtvkitGlueClient.getInstance().unregisterSignalHandler(mHandler);
    }

    private void startMonitoringSync() {
        LocalBroadcastManager.getInstance(this).registerReceiver(mReceiver,
                new IntentFilter(EpgSyncJobService.ACTION_SYNC_STATUS_CHANGED));
    }

    private void stopMonitoringSync() {
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mReceiver);
    }

   private String playerGetDefaultSubtitlesLanguageCode()
   {
      String code = "";
      JSONArray args = new JSONArray();
      try
      {
         code =
            DtvkitGlueClient.getInstance().request("Player.getDefaultSubtitlesLanguage", args)
               .getJSONObject("data").getString("code");
      }
      catch (Exception e)
      {
         Log.e(TAG, e.getMessage());
      }

      return code;
   }

   private boolean playerSetDefaultSubtitlesLanguage(String code)
   {
      boolean success = false;
      JSONArray args = new JSONArray();
      args.put(code);
      try
      {
         success =
            DtvkitGlueClient.getInstance().request("Player.setDefaultSubtitlesLanguage", args)
               .getBoolean("data");
      }
      catch (Exception e)
      {
         Log.e(TAG, e.getMessage());
      }

      return success;
   }

   private void updateDefaultLanguage()
   {
      String langCode = Locale.getDefault().getISO3Language();
      String defaultSubtitlesLangCode = playerGetDefaultSubtitlesLanguageCode();
      Log.d(TAG, "System lang code: " + langCode);

       if ("zho".equals(langCode)) {
          langCode = "chi";
       }

      if (playerSetDefaultSubtitlesLanguage(langCode))
      {
         Log.d(TAG, "Default subtitles language changed from " + defaultSubtitlesLangCode +
            " to " + langCode);
      }
   }

   private int getBouquetId() {
       Log.d(TAG, "getBouquetId()");
       int bouquetId = 25149;

       String sBouquetId = SystemProperties.get("persist.vendor.dvb.bid");
       if ((sBouquetId != null) && (!sBouquetId.equals(""))) {
	    return Integer.parseInt(sBouquetId);
       }

       DtvkitGlueClient mDtvkitGlueClient = DtvkitGlueClient.getInstance();
       try {
           JSONArray args = new JSONArray();
           JSONObject ret = mDtvkitGlueClient.request("Cas.getOperatorIds", args).getJSONObject("data");
           JSONArray tvsidArray = ret.getJSONObject("data").getJSONArray ("tvsid");
           
           for (int i = 0, size = tvsidArray.length(); i < size; i++) {
               int tvsid = tvsidArray.getInt(i);
               if (0 != tvsid) {
                   args = new JSONArray();
                   args.put(tvsid);
                   JSONObject ret2 = mDtvkitGlueClient.request("Cas.getACList", args).getJSONObject("data");
                   JSONArray acArray = ret2.getJSONObject("data").getJSONArray ("ac_array");
                   long bid = acArray.getLong(1);
                   bid &= 0xFFFF;
                   if (0 != bid) {
                       bouquetId = (int)bid;
                       Log.d(TAG, "operator ID: " + tvsid + " bouquet iD: " + bouquetId);
                       break;
                   }
               }
           }
       } catch (Exception e) {
           Log.e(TAG, e.getMessage());
       }
       
       return bouquetId;
   }

    private void modifyBouquetId() {
	AlertDialog.Builder editDialog = new AlertDialog.Builder(HomeplusSearchChannelAll.this);
	editDialog.setTitle("修改 Bouquet ID");

	final EditText editText = new EditText(HomeplusSearchChannelAll.this);
	editText.setInputType(InputType.TYPE_NULL);
	editText.setText("" + getBouquetId());
	editText.setOnKeyListener(new View.OnKeyListener() {
	    @Override
	    public boolean onKey(View v, int keyCode, KeyEvent event) {
		if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
		    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
			if (!editText.getText().toString().equals("")) {
			    new Thread() {
				@Override
				public void run() {
				    try {
					Instrumentation inst = new Instrumentation();
					inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
				    } catch (Exception e) {
					 Log.d(TAG, "" + e);
				    }
				}
			   }.start();
			   return true;
			}
		    }
		}
		return false;
	    }
	});

	editDialog.setView(editText);
	editDialog.setPositiveButton("OK", new DialogInterface.OnClickListener() {
	    public void onClick(DialogInterface arg0, int arg1) {
		String newBID = editText.getText().toString();
		SystemProperties.set("persist.vendor.dvb.bid", newBID);
		tvBID.setText(newBID);
	    }
	});
	editDialog.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
	    public void onClick(DialogInterface arg0, int arg1) {
	    }
	});
	editDialog.show();
    }
}
