package org.dtvkit.inputsource;

import android.app.Activity;
import android.app.Instrumentation;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Gravity;
import android.view.View;
import android.text.InputType;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import android.support.v7.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;


public class HomeplusSignalDetection extends AppCompatActivity {
    private String TAG = "HomeplusSignalDetection";
    private static final boolean DEBUG = true;

    private TextView tvTitle, tvSubtitle;
    private TextView tvQamTick, tvQamValue, tvBIDTitle, tvBID;
    private EditText etFrequency,etSR;
    private Button btnQAM, btnSearch, btnCancel;
    private String[] qamItems;
    private boolean networkScan;
    private int qamIndex = 4; //256
    int qamValueCurrent = 256;
    private TextView tvBer, tvSNR, tvStrength, tvSearchProgress;
    private ProgressBar pbSNR, pbStrength;
    private LinearLayout llSearchProgress;

    private boolean mStarted;
    private Timer mTimer;
    private StatusTimerTask mStatusTimerTask;

    public class StatusTimerTask extends TimerTask {
        public void run() {
            try {
                JSONArray args = new JSONArray();
                JSONObject data =
                        DtvkitGlueClient.getInstance().request(
                            "Dvbc.getSignalStatus",
                             args
                        ).getJSONObject("data");

                int bitErrorRate = 10000000;
                int signalNoiseRatio = 0;
                int signalStrength = 0;
                try {
                    bitErrorRate = data.getInt("bit-error-rate");
                    signalNoiseRatio = data.getInt("signal-noise-ratio");
                    signalStrength = data.getInt("signal-strength");

                } catch (JSONException ignore) {
                }

		Log.d(TAG, "[signal] BER: " + bitErrorRate + ", SNR: " + signalNoiseRatio + ", Strength: " + signalStrength);
		Bundle bundle = new Bundle();
                bundle.putInt("BER", bitErrorRate);
                bundle.putInt("SNR", signalNoiseRatio);
                bundle.putInt("STRENGTH", signalStrength);
                Message msg = new Message();
                msg.setData(bundle);
                mHandler2.sendMessage(msg);
            } catch (JSONException e) {
                e.printStackTrace();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (DEBUG) Log.d(TAG, "onCreate");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.homeplus_signal_detection);

        mStarted = false;
	qamIndex = 4;
        initLayout();
	tvTitle.setText("訊號檢測");
	tvSubtitle.setText("按下檢測鍵進行檢測");
	btnSearch.setText("訊號檢測");
	tvBIDTitle.setVisibility(View.GONE);
	tvBID.setVisibility(View.GONE);
	tvSearchProgress.setVisibility(View.GONE);
	llSearchProgress.setVisibility(View.GONE);
    }

    //private TextView tvDetection;

    private void initLayout() {
	tvTitle = (TextView) findViewById(R.id.tvTitle);
	tvSubtitle = (TextView) findViewById(R.id.tvSubtitle);
        etFrequency = (EditText) findViewById(R.id.etFrequency);
        etSR = (EditText) findViewById(R.id.etSR);
        btnQAM = (Button) findViewById(R.id.btnQAM);
        btnSearch = (Button) findViewById(R.id.btnSearch);
        btnCancel = (Button) findViewById(R.id.btnCancel);
	tvQamTick = (TextView) findViewById(R.id.tvQamTick);
	tvQamValue = (TextView) findViewById(R.id.tvQamValue);
	tvBIDTitle = (TextView) findViewById(R.id.tvBIDTitle);
	tvBID = (TextView) findViewById(R.id.tvBID);
	tvBer = (TextView) findViewById(R.id.tvBer);
	tvSNR = (TextView) findViewById(R.id.tvSNR);
	tvStrength = (TextView) findViewById(R.id.tvStrength);
	tvSearchProgress = (TextView) findViewById(R.id.tvSearchProgress);
        pbSNR = (ProgressBar) findViewById(R.id.pbSNR);
        pbStrength = (ProgressBar) findViewById(R.id.pbStrength);
        llSearchProgress = (LinearLayout) findViewById(R.id.llSearchProgress);

        qamItems = getResources().getStringArray(R.array.qam_list);

	etFrequency.setInputType(InputType.TYPE_NULL);
        etFrequency.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etFrequency.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

	etSR.setInputType(InputType.TYPE_NULL);
        etSR.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etSR.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        btnQAM.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                } else {
		    //redraw to show the current QAM setting
		    int qval = Integer.parseInt(tvQamValue.getText().toString());
		    if (qval != qamValueCurrent) {
			//find current qam index
			for (int i=0; i < qamItems.length; i++) {
			    if (Integer.parseInt(qamItems[i]) == qamValueCurrent) {
				qamIndex = i;
				break;
			    }
			}
			Log.d(TAG, "recovery QAM show text to " + qamItems[qamIndex]);
			tvQamValue.setText(qamItems[qamIndex]);
			tvQamTick.setVisibility(View.VISIBLE);
		    }
                }
            }

        });

        btnQAM.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			qamValueCurrent = Integer.parseInt(qamItems[qamIndex]);
			Log.d(TAG, "qamValueCurrent set to " + qamValueCurrent);
			tvQamTick.setVisibility(View.VISIBLE);

                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_DOWN) {
			btnSearch.requestFocus();
                        return true;
                    }
                }
                return false;
            }
        });

        btnSearch.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                    } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			if (btnSearch.getText().toString().equals("停止檢測")) {
			    stopDetection();
			    tvSubtitle.setText("按下檢測鍵進行檢測");
			    btnSearch.setText("訊號檢測");

			    return true;
			}

			//check parameters
			if (etFrequency.getText().toString().equals("") ||
			    etSR.getText().toString().equals("")) {
			    String msg = "檢測參數錯誤";
			    Toast toast = Toast.makeText(HomeplusSignalDetection.this, msg, Toast.LENGTH_SHORT);
			    toast.setGravity(Gravity.CENTER, 0, 0);
			    toast.show();

			    return true;
			}

			//change layout
			tvSubtitle.setText("檢測中...");
			btnSearch.setText("停止檢測");

			startDetection();
			return true;
                    }
                }
                return false;
            }
        });

        btnCancel.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
			//return code
			setResult(RESULT_OK, getIntent());

			//finish
			HomeplusSignalDetection.this.finish();
			return true;

                    }
                }
                return false;
            }
        });
    }

    private void nextResolution(int keyCode) {
        if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
            qamIndex = qamIndex - 1;
            if (qamIndex == -1) {
                qamIndex = qamItems.length - 1;
            }
        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
            qamIndex = qamIndex + 1;
            if (qamIndex == qamItems.length) {
                qamIndex = 0;
            }
        } else {

        }

	if (qamValueCurrent == Integer.parseInt(qamItems[qamIndex])) {
	    tvQamTick.setVisibility(View.VISIBLE);
	} else {
	    tvQamTick.setVisibility(View.INVISIBLE);
	}
        tvQamValue.setText(qamItems[qamIndex]);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
	    //FIXME - not allow back?
	    setResult(1, getIntent());
            finish();
        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        if (DEBUG) Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        if (DEBUG) Log.d(TAG, "onPause");
        super.onPause();
    }

    @Override
    public void onDestroy() {
        if (DEBUG) Log.d(TAG, "onDestroy");
        super.onDestroy();
        stopDetection();
        stopMonitoringSearch();
    }

    private Handler mHandler2 = new Handler() {
	public void handleMessage(Message msg) {
	    super.handleMessage(msg);
	    int bitErrorRate = msg.getData().getInt("BER");
	    int signalNoiseRatio = msg.getData().getInt("SNR");
	    int signalStrength = msg.getData().getInt("STRENGTH");

	    Log.d(TAG, "handle [signal] BER: " + bitErrorRate + ", SNR: " + signalNoiseRatio + ", Strength: " + signalStrength);
	    if (bitErrorRate == 0)
		tvBer.setText(String.valueOf(bitErrorRate));
	    else
		tvBer.setText(String.format(Locale.ENGLISH, "%dE-7", bitErrorRate));
	    tvSNR.setText(Integer.toString(signalNoiseRatio));
	    pbSNR.setProgress(signalNoiseRatio);
	    tvStrength.setText(Integer.toString(signalStrength));
	    pbStrength.setProgress(signalStrength);
	}
    };
    // =============================================================================
    private final DtvkitGlueClient.SignalHandler mHandler = new DtvkitGlueClient.SignalHandler() {
        @Override
        public void onSignal(String signal, JSONObject data) {
            if (signal.equals("DvbcStatusChanged")) {
                int bitErrorRate = 10000000;
                int signalNoiseRatio = 0;
                int signalStrength = 0;
                try {
                    bitErrorRate = data.getInt("bit-error-rate");
                    signalNoiseRatio = data.getInt("signal-noise-ratio");
                    signalStrength = data.getInt("signal-strength");
                } catch (JSONException ignore) {
                }

		Log.d(TAG, "[signal] BER: " + bitErrorRate + ", SNR: " + signalNoiseRatio + ", Strength: " + signalStrength);
		Bundle bundle = new Bundle();
                bundle.putInt("BER", bitErrorRate);
                bundle.putInt("SNR", signalNoiseRatio);
                bundle.putInt("STRENGTH", signalStrength);
                Message msg = new Message();
                msg.setData(bundle);
                mHandler2.sendMessage(msg);
            }
        }
    };

    private void startDetection() {
        if (DEBUG) Log.i(TAG, "startDetection");
        if (mStarted)
            stopDetection();

        startMonitoringSearch();
        //tvDetection.setText(R.string.check);
        try {
            JSONArray args = new JSONArray();
            Integer frequencyHz = Integer.parseInt(etFrequency.getText().toString() + String.valueOf("000"));

            args.put(frequencyHz);
            args.put(String.valueOf("qam") + qamValueCurrent);
            args.put(Integer.parseInt(etSR.getText().toString()));
            args.put(String.valueOf("6MHz"));
            if (DEBUG) Log.i(TAG, args.toString());

            DtvkitGlueClient.getInstance().request("Dvbc.startSignalDetection", args);
        } catch (Exception e) {
            stopMonitoringSearch();
        }
    }

    private void stopDetection() {
        if (DEBUG) Log.i(TAG, "stopDetection");
        stopMonitoringSearch();
        //tvDetection.setText(null);
        try {
            JSONArray args = new JSONArray();
            DtvkitGlueClient.getInstance().request("Dvbc.stopSignalDetection", args);
        } catch (Exception e) {

        }
    }

    private void startMonitoringSearch() {
        mStarted = true;
        DtvkitGlueClient.getInstance().registerSignalHandler(mHandler);
        mTimer = new Timer();
        if (null != mTimer) {
            mTimer.scheduleAtFixedRate(new StatusTimerTask(), 0, 1000);
        }
    }

    private void stopMonitoringSearch() {
        if (null != mTimer) {
            mTimer.cancel();
            mTimer = null;
        }
        DtvkitGlueClient.getInstance().unregisterSignalHandler(mHandler);
        mStarted = false;
    }
}
