package org.dtvkit.inputsource;

import android.os.RemoteException;
import android.util.Log;
import android.view.Surface;

import vendor.dtvkit.hardware.dtvkit.V1_0.IDTVKit;
//import vendor.dtvkit.hardware.dtvkit.V1_0.IDTVKitSignalHandler;
//import vendor.dtvkit.hardware.dtvkit.V1_0.IDTVKitOverlayTarget;

public class Platform
{
   IDTVKit mDTVKit;
	
   private native boolean setNativeSurface(Surface surface);

   private native void unsetNativeSurface();

   private native int getNativeSurfaceX();

   private native int getNativeSurfaceY();

   private native int getNativeSurfaceWidth();

   private native int getNativeSurfaceHeight();

   private native boolean setNativeVideoWindowHandle(long handle);
   
   private native int setNativeVideoSurface(int type, Surface surface, boolean isPip);

   public Platform()
   {
      try {
         mDTVKit = IDTVKit.getService();
      }
      catch (RemoteException e) {
            Log.wtf("DTVKIT", e.getMessage());
      }
   }

   public Boolean setSurface(Surface surface)
   {
      boolean success = false;

      unsetNativeSurface();
      if (surface != null)
      {
         success = setNativeSurface(surface);
      }
      else
      {
         success = true;
      }

      return success;
   }

   public int getSurfaceX()
   {
      return getNativeSurfaceX();
   }

   public int getSurfaceY()
   {
      return getNativeSurfaceY();
   }

   public int getSurfaceWidth()
   {
      return getNativeSurfaceWidth();
   }

   public int getSurfaceHeight()
   {
      return getNativeSurfaceHeight();
   }

   public Boolean setVideoWindowHandle(long handle)
   {
      setNativeVideoWindowHandle(handle);
      return true;
   }

   public int setVideoSurface(int type, Surface surface, boolean isPip)
   {
      return setNativeVideoSurface(type, surface, isPip);
   }

   static
   {
      System.loadLibrary("dtvkit_inputsource_jni");
   }
}
