package org.dtvkit.inputsource;

import android.app.Activity;
import android.app.Instrumentation;
import android.os.Bundle;
import android.os.SystemProperties;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

import org.dtvkit.inputsource.DtvkitGlueClient;
import org.dtvkit.inputsource.R;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.tv.TvContract;
import android.media.tv.TvInputInfo;
import android.support.v4.content.LocalBroadcastManager;
import android.widget.Spinner;
import android.widget.TextView;

import java.util.Locale;

import org.dtvkit.companionlibrary.EpgSyncJobService;
import org.dtvkit.companionlibrary.model.Channel;
import org.dtvkit.companionlibrary.utils.TvContractUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


public class SearchChannel extends Activity {
    private String TAG = "DTV-SearchChannel";
    private static boolean DEBUG = true;

    private ListView lvSearchChanel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.search_channel);

        setSettingsLeft();
        networkScan = true;
        updateDefaultLanguage();
    }

    private RelativeLayout rlSettingList, rlSearchChannel;
    private EditText etFrequency,etSR;
    private Button btnQAM;

    private String[] qamItems;

    private boolean networkScan;
    private TextView tvBer, tvSNR, tvStrength, tvProgress;
    private ProgressBar pbSNR, pbStrength, pbProgress;
    private TextView tvDetection;


    private void setSettingsLeft() {
        rlSettingList = (RelativeLayout) findViewById(R.id.rlSettingList);
        rlSearchChannel = (RelativeLayout) findViewById(R.id.rlSearchChannel);

        etFrequency = (EditText) findViewById(R.id.etFrequency);
        etSR = (EditText) findViewById(R.id.etSR);

        btnQAM = (Button) findViewById(R.id.btnQAM);

        tvBer = (TextView) findViewById(R.id.tvBer);
        tvSNR = (TextView) findViewById(R.id.tvSNR);
        tvStrength = (TextView) findViewById(R.id.tvStrength);
        tvProgress = (TextView) findViewById(R.id.tvProgress);

        pbSNR = (ProgressBar) findViewById(R.id.pbSNR);
        pbStrength = (ProgressBar) findViewById(R.id.pbStrength);
        pbProgress = (ProgressBar) findViewById(R.id.pbProgress);

        tvDetection = (TextView) findViewById(R.id.tvDetection);

        etFrequency.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_blue_line);
                } else {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_gary_line);
                }
            }

        });

        etSR.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_blue_line);
                } else {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_gary_line);
                }
            }

        });


        btnQAM.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_blue_line);
                } else {
                    rlSearchChannel.setBackgroundResource(R.drawable.round_corner_square_gary_line);
                }
            }

        });

        String[] settingItems = getResources().getStringArray(R.array.search_channel_list);

        lvSearchChanel = (ListView) findViewById(R.id.lvSearchChanel);

        ListAdapter adapter = new ArrayAdapter<String>(this, R.layout.list_item, settingItems);
        lvSearchChanel.setAdapter(adapter);

        lvSearchChanel.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                showSettingsRight(position);
                if (0 == position)
                    networkScan = true;
                else
                    networkScan = false;

                if (DEBUG) Log.i(TAG, "onItemSelected networkScan " + networkScan + " position " + position);
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });

        lvSearchChanel.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                showSettingsRight(position);
            }
        });

        lvSearchChanel.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View arg0, boolean hasFocus) {
                if (hasFocus) {
                    rlSettingList.setBackgroundResource(R.drawable.round_corner_square_blue_line);
                } else {
                    rlSettingList.setBackgroundResource(R.drawable.round_corner_square_gary_line);
                }
            }

        });

        qamItems = getResources().getStringArray(R.array.qam_list);

        etFrequency.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etFrequency.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        etSR.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etSR.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        btnQAM.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {
                        //rlSettingList.requestFocus();
                        //return true;
                    } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {

                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
                        nextResolution(keyCode);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private int qamIndex = 0;

    private void nextResolution(int keyCode) {
        if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
            qamIndex = qamIndex - 1;
            if (qamIndex == -1) {
                qamIndex = qamItems.length - 1;
            }
        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
            qamIndex = qamIndex + 1;
            if (qamIndex == qamItems.length) {
                qamIndex = 0;
            }
        } else {

        }

        btnQAM.setText(qamItems[qamIndex]);
    }

    private void showSettingsRight(int index) {
        switch (index) {
            case 0:
                break;
            case 1:
                break;
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            finish();
        } else if (keyCode == KeyEvent.KEYCODE_PAGE_UP || keyCode == KeyEvent.KEYCODE_CHANNEL_UP) {

        } else if (keyCode == KeyEvent.KEYCODE_PAGE_DOWN || keyCode == KeyEvent.KEYCODE_CHANNEL_DOWN) {

        } else if (keyCode == KeyEvent.KEYCODE_MENU || keyCode == KeyEvent.KEYCODE_INFO) {

        } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {

        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_RED || keyCode == KeyEvent.KEYCODE_F9) {
            startSearch();
        } else if (keyCode == KeyEvent.KEYCODE_PROG_GREEN) {

        } else if (keyCode == KeyEvent.KEYCODE_PROG_BLUE) {

        } else if (keyCode == KeyEvent.KEYCODE_GUIDE) {

        } else if (keyCode == KeyEvent.KEYCODE_MEDIA_AUDIO_TRACK) {

        }

        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onResume() {
        if (DEBUG) Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        if (DEBUG) Log.d(TAG, "onPause");
        super.onPause();
    }

    @Override
    public void onDestroy() {
        if (DEBUG) Log.d(TAG, "onDestroy");
        super.onDestroy();
        stopMonitoringSearch();
        stopMonitoringSync();
    }

    // =============================================================================
    private final DtvkitGlueClient.SignalHandler mHandler = new DtvkitGlueClient.SignalHandler() {
        @Override
        public void onSignal(String signal, JSONObject data) {
            if (signal.equals("DvbcStatusChanged")) {
                int progress = 0;
                int bitErrorRate = 10000000;
                int signalNoiseRatio = 0;
                int signalStrength = 0;
                try {
                    progress = data.getInt("progress");
                    if (progress > 100)
                        progress = 100;

                    bitErrorRate = data.getInt("bit-error-rate");
                    signalNoiseRatio = data.getInt("signal-noise-ratio");
                    signalStrength = data.getInt("signal-strength");

                } catch (JSONException ignore) {
                }
                if (DEBUG || true) Log.i(TAG, "onSignal BER " + bitErrorRate + "E-7");
                if (0 == bitErrorRate)
                    tvBer.setText(String.valueOf(bitErrorRate));
                else
                    tvBer.setText(String.format(Locale.ENGLISH, "%dE-7", bitErrorRate));

                if (DEBUG || true) Log.i(TAG, "onSignal SNR " + signalNoiseRatio + "dB");
                tvSNR.setText(String.format(Locale.ENGLISH, "%ddB", signalNoiseRatio));
                pbSNR.setProgress(signalNoiseRatio);

                if (DEBUG || true) Log.i(TAG, "onSignal Strength " + signalStrength + "dBuV");
                tvStrength.setText(String.format(Locale.ENGLISH, "%ddBuV", signalStrength));
                pbStrength.setProgress(signalStrength);

                if (DEBUG || true) Log.i(TAG, "onSignal progress " + progress);
                tvProgress.setText(String.format(Locale.ENGLISH, "%d%%", progress));
                pbProgress.setProgress(progress);
                if (progress == 100) {
                    //pbProgress.setIndeterminate(true);
                    onSearchFinished();
                }
            }
        }
    };

    private final BroadcastReceiver mReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, final Intent intent) {
            String status = intent.getStringExtra(EpgSyncJobService.SYNC_STATUS);
            if (status.equals(EpgSyncJobService.SYNC_FINISHED)) {
                // reset
                tvBer.setText("0");
                tvSNR.setText("0dB");
                pbSNR.setProgress(0);
                tvStrength.setText("0dBuV");
                pbStrength.setProgress(0);

                //pbProgress.setIndeterminate(false);
                //pbProgress.setProgress(100);
                int numberOfServices = 0;
                int videoServices = 0;
                int audioServices = 0;
                int otherServices = 0;
                String inputId = TvContract.buildInputId(new ComponentName(context, DtvkitTvInput.class));
                LongSparseArray<Channel> channelMap = 
                    TvContractUtils.buildChannelMap(context.getContentResolver(), inputId);
                if (null != channelMap) {
                    numberOfServices = channelMap.size();
                    for(int i = 0;  i < numberOfServices; i++) {
                        Channel channel = channelMap.valueAt(i);
                        if (null != channel) {
                            String serviceType = channel.getServiceType();
                            if (TvContract.Channels.SERVICE_TYPE_AUDIO_VIDEO.equals(serviceType)) {
                                videoServices ++;
                            }
                            else if (TvContract.Channels.SERVICE_TYPE_AUDIO.equals(serviceType)) {
                                audioServices ++;
                            }
                            else if (TvContract.Channels.SERVICE_TYPE_OTHER.equals(serviceType)) {
                                otherServices ++;
                            }
                        }
                    }
                }          
                String scanResult = getResources().getString(R.string.searched);
                scanResult += String.valueOf("!  ");
                scanResult += getResources().getString(R.string.tv);
                scanResult += String.valueOf(": ");
                scanResult += String.valueOf(videoServices);
                scanResult += String.valueOf(", ");
                scanResult += getResources().getString(R.string.radio);
                scanResult += String.valueOf(": ");
                scanResult += String.valueOf(audioServices);
                scanResult += String.valueOf(", ");
                scanResult += getResources().getString(R.string.data);
                scanResult += String.valueOf(": ");
                scanResult += String.valueOf(otherServices);
                String otherResult = getResources().getString(R.string.data);

                tvDetection.setText(scanResult);
                //finish();
            }
        }
    };

    private void startSearch() {
        startMonitoringSearch();
        tvDetection.setText(R.string.searching);
        //FIXME: workaround for selinux failure
        //SystemProperties.set("persist.vendor.dvb.netscan", (networkScan==true)?"1":"0");
        try {
            JSONArray args = new JSONArray();
            Integer frequencyHz = Integer.parseInt(etFrequency.getText().toString() + String.valueOf("000"));

            args.put(networkScan);
            args.put(frequencyHz);
            args.put(String.valueOf("qam") + btnQAM.getText().toString());
            args.put(Integer.parseInt(etSR.getText().toString()));
            args.put(true); // retune
            args.put(frequencyHz);
            args.put(String.valueOf("6MHz"));
            args.put(getBouquetId());

            if (DEBUG) Log.i(TAG, args.toString());

            DtvkitGlueClient.getInstance().request("Dvbc.startManualSearch", args);
        } catch (Exception e) {
            stopMonitoringSearch();
        }
    }

    private void onSearchFinished() {
        stopMonitoringSearch();
        try {
            JSONArray args = new JSONArray();
            args.put(true); // Commit
            DtvkitGlueClient.getInstance().request("Dvbc.finishSearch", args);
        } catch (Exception e) {
            stopMonitoringSearch();
            return;
        }

        startMonitoringSync();
        // By default, gets all channels and 1 hour of programs (DEFAULT_IMMEDIATE_EPG_DURATION_MILLIS)
        EpgSyncJobService.cancelAllSyncRequests(this);

        // If the intent that started this activity is from Live Channels app
        //String inputId = this.getIntent().getStringExtra(TvInputInfo.EXTRA_INPUT_ID);
        String inputId = TvContract.buildInputId(new ComponentName(getApplicationContext(), DtvkitTvInput.class));
        Log.i(TAG, String.format("inputId: %s", inputId));
        EpgSyncJobService.requestImmediateSync(this, inputId,
                EpgSyncJobService.SYNC_MODE_NOW_NEXT, true,
                new ComponentName(this, DtvkitEpgSync.class));
    }

    private void startMonitoringSearch() {
        DtvkitGlueClient.getInstance().registerSignalHandler(mHandler);
    }

    private void stopMonitoringSearch() {
        DtvkitGlueClient.getInstance().unregisterSignalHandler(mHandler);
    }

    private void startMonitoringSync() {
        LocalBroadcastManager.getInstance(this).registerReceiver(mReceiver,
                new IntentFilter(EpgSyncJobService.ACTION_SYNC_STATUS_CHANGED));
    }

    private void stopMonitoringSync() {
        LocalBroadcastManager.getInstance(this).unregisterReceiver(mReceiver);
    }

   private String playerGetDefaultSubtitlesLanguageCode()
   {
      String code = "";
      JSONArray args = new JSONArray();
      try
      {
         code =
            DtvkitGlueClient.getInstance().request("Player.getDefaultSubtitlesLanguage", args)
               .getJSONObject("data").getString("code");
      }
      catch (Exception e)
      {
         Log.e(TAG, e.getMessage());
      }

      return code;
   }

   private boolean playerSetDefaultSubtitlesLanguage(String code)
   {
      boolean success = false;
      JSONArray args = new JSONArray();
      args.put(code);
      try
      {
         success =
            DtvkitGlueClient.getInstance().request("Player.setDefaultSubtitlesLanguage", args)
               .getBoolean("data");
      }
      catch (Exception e)
      {
         Log.e(TAG, e.getMessage());
      }

      return success;
   }

   private void updateDefaultLanguage()
   {
      String langCode = Locale.getDefault().getISO3Language();
      String defaultSubtitlesLangCode = playerGetDefaultSubtitlesLanguageCode();
      Log.d(TAG, "System lang code: " + langCode);

       if ("zho".equals(langCode)) {
          langCode = "chi";
       }

      if (playerSetDefaultSubtitlesLanguage(langCode))
      {
         Log.d(TAG, "Default subtitles language changed from " + defaultSubtitlesLangCode +
            " to " + langCode);
      }
   }

   private int getBouquetId() {
       Log.d(TAG, "getBouquetId()");
       int bouquetId = 25149;

       String sBouquetId = SystemProperties.get("persist.vendor.dvb.bid");
       if ((sBouquetId != null) && (!sBouquetId.equals(""))) {
	    return Integer.parseInt(sBouquetId);
       }

       DtvkitGlueClient mDtvkitGlueClient = DtvkitGlueClient.getInstance();
       try {
           JSONArray args = new JSONArray();
           JSONObject ret = mDtvkitGlueClient.request("Cas.getOperatorIds", args).getJSONObject("data");
           JSONArray tvsidArray = ret.getJSONObject("data").getJSONArray ("tvsid");
           
           for (int i = 0, size = tvsidArray.length(); i < size; i++) {
               int tvsid = tvsidArray.getInt(i);
               if (0 != tvsid) {
                   args = new JSONArray();
                   args.put(tvsid);
                   JSONObject ret2 = mDtvkitGlueClient.request("Cas.getACList", args).getJSONObject("data");
                   JSONArray acArray = ret2.getJSONObject("data").getJSONArray ("ac_array");
                   long bid = acArray.getLong(1);
                   bid &= 0xFFFF;
                   if (0 != bid) {
                       bouquetId = (int)bid;
                       Log.d(TAG, "operator ID: " + tvsid + " bouquet iD: " + bouquetId);
                       break;
                   }
               }
           }
       } catch (Exception e) {
           Log.e(TAG, e.getMessage());
       }
       
       return bouquetId;
   }
}
