package org.dtvkit.inputsource;

import android.app.Activity;
import android.app.Instrumentation;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;

import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


public class SignalDetection extends Activity {
    private String TAG = "DTV-SignalDetection";
    private static final boolean DEBUG = true;

    private boolean mStarted;
    private Timer mTimer;
    private StatusTimerTask mStatusTimerTask;

    public class StatusTimerTask extends TimerTask {
        public void run() {
            try {
                JSONArray args = new JSONArray();
                JSONObject data =
                        DtvkitGlueClient.getInstance().request(
                            "Dvbc.getSignalStatus",
                             args
                        ).getJSONObject("data");

                int bitErrorRate = 10000000;
                int signalNoiseRatio = 0;
                int signalStrength = 0;
                try {
                    bitErrorRate = data.getInt("bit-error-rate");
                    signalNoiseRatio = data.getInt("signal-noise-ratio");
                    signalStrength = data.getInt("signal-strength");

                } catch (JSONException ignore) {
                }
                if (DEBUG || true) Log.i(TAG, "onSignal BER " + bitErrorRate + "E-7");
                if (0 == bitErrorRate)
                    tvBer.setText(String.valueOf(bitErrorRate));
                else
                    tvBer.setText(String.format(Locale.ENGLISH, "%dE-7", bitErrorRate));

                if (DEBUG || true) Log.i(TAG, "onSignal SNR " + signalNoiseRatio + "dB");
                tvSNR.setText(String.format(Locale.ENGLISH, "%ddB", signalNoiseRatio));
                pbSNR.setProgress(signalNoiseRatio);

                if (DEBUG || true) Log.i(TAG, "onSignal Strength " + signalStrength + "dBuV");
                tvStrength.setText(String.format(Locale.ENGLISH, "%ddBuV", signalStrength));
                pbStrength.setProgress(signalStrength);
            } catch (JSONException e) {
                e.printStackTrace();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (DEBUG) Log.d(TAG, "onCreate");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.signal_detection);

        mStarted = false;
        setSettingsLeft();
    }

    private EditText etFrequency,etSR;
    private Button btnQAM;

    private String[] qamItems;

    private TextView tvBer, tvSNR, tvStrength, tvProgress;
    private ProgressBar pbSNR, pbStrength, pbProgress;
    private TextView tvDetection;

    private void setSettingsLeft() {
        etFrequency = (EditText) findViewById(R.id.etFrequency);
        etSR = (EditText) findViewById(R.id.etSR);

        btnQAM = (Button) findViewById(R.id.btnQAM);

        tvBer = (TextView) findViewById(R.id.tvBer);
        tvSNR = (TextView) findViewById(R.id.tvSNR);
        tvStrength = (TextView) findViewById(R.id.tvStrength);
        tvProgress = (TextView) findViewById(R.id.tvProgress);

        pbSNR = (ProgressBar) findViewById(R.id.pbSNR);
        pbStrength = (ProgressBar) findViewById(R.id.pbStrength);
        pbProgress = (ProgressBar) findViewById(R.id.pbProgress);

        tvDetection = (TextView) findViewById(R.id.tvDetection);

        qamItems = getResources().getStringArray(R.array.qam_list);

        etFrequency.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etFrequency.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        etSR.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        if (!etSR.getText().toString().equals("")) {
                            new Thread() {
                                @Override
                                public void run() {
                                    try {
                                        Instrumentation inst = new Instrumentation();
                                        inst.sendKeyDownUpSync(KeyEvent.KEYCODE_DEL);
                                    } catch (Exception e) {
                                         Log.d(TAG, "" + e);
                                    }
                                }
                           }.start();
                           return true;
                        }
                    }
                }
                return false;
            }
        });

        btnQAM.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN)) {
                    if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
                        nextResolution(keyCode);
                        return true;
                    } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
                        nextResolution(keyCode);
                        return true;
                    }
                }
                return false;
            }
        });
    }

    private int qamIndex = 0;

    private void nextResolution(int keyCode) {
        if (keyCode == KeyEvent.KEYCODE_DPAD_LEFT) {
            qamIndex = qamIndex - 1;
            if (qamIndex == -1) {
                qamIndex = qamItems.length - 1;
            }
        } else if (keyCode == KeyEvent.KEYCODE_DPAD_RIGHT) {
            qamIndex = qamIndex + 1;
            if (qamIndex == qamItems.length) {
                qamIndex = 0;
            }
        } else {

        }

        btnQAM.setText(qamItems[qamIndex]);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            //stopDetection();
            finish();
        } else if (keyCode == KeyEvent.KEYCODE_ENTER || keyCode == KeyEvent.KEYCODE_DPAD_CENTER) {
            startDetection();
            return true;
        }

        return false;
    }

    @Override
    public void onResume() {
        if (DEBUG) Log.d(TAG, "onResume");
        super.onResume();
    }

    @Override
    public void onPause() {
        if (DEBUG) Log.d(TAG, "onPause");
        super.onPause();
    }

    @Override
    public void onDestroy() {
        if (DEBUG) Log.d(TAG, "onDestroy");
        stopDetection();
        super.onDestroy();
        stopMonitoringSearch();
    }

    // =============================================================================
    private final DtvkitGlueClient.SignalHandler mHandler = new DtvkitGlueClient.SignalHandler() {
        @Override
        public void onSignal(String signal, JSONObject data) {
            if (signal.equals("DvbcStatusChanged")) {
                int bitErrorRate = 10000000;
                int signalNoiseRatio = 0;
                int signalStrength = 0;
                try {
                    bitErrorRate = data.getInt("bit-error-rate");
                    signalNoiseRatio = data.getInt("signal-noise-ratio");
                    signalStrength = data.getInt("signal-strength");

                } catch (JSONException ignore) {
                }
                if (DEBUG || true) Log.i(TAG, "onSignal BER " + bitErrorRate + "E-7");
                if (0 == bitErrorRate)
                    tvBer.setText(String.valueOf(bitErrorRate));
                else
                    tvBer.setText(String.format(Locale.ENGLISH, "%dE-7", bitErrorRate));

                if (DEBUG || true) Log.i(TAG, "onSignal SNR " + signalNoiseRatio + "dB");
                tvSNR.setText(String.format(Locale.ENGLISH, "%ddB", signalNoiseRatio));
                pbSNR.setProgress(signalNoiseRatio);

                if (DEBUG || true) Log.i(TAG, "onSignal Strength " + signalStrength + "dBuV");
                tvStrength.setText(String.format(Locale.ENGLISH, "%ddBuV", signalStrength));
                pbStrength.setProgress(signalStrength);
            }
        }
    };

    private void startDetection() {
        if (DEBUG) Log.i(TAG, "startDetection");
        if (mStarted)
            stopDetection();

        startMonitoringSearch();
        tvDetection.setText(R.string.check);
        try {
            JSONArray args = new JSONArray();
            Integer frequencyHz = Integer.parseInt(etFrequency.getText().toString() + String.valueOf("000"));

            args.put(frequencyHz);
            args.put(String.valueOf("qam") + btnQAM.getText().toString());
            args.put(Integer.parseInt(etSR.getText().toString()));
            args.put(String.valueOf("6MHz"));
            if (DEBUG) Log.i(TAG, args.toString());

            DtvkitGlueClient.getInstance().request("Dvbc.startSignalDetection", args);
        } catch (Exception e) {
            stopMonitoringSearch();
        }
    }

    private void stopDetection() {
        if (DEBUG) Log.i(TAG, "stopDetection");
        stopMonitoringSearch();
        tvDetection.setText(null);
        try {
            JSONArray args = new JSONArray();
            DtvkitGlueClient.getInstance().request("Dvbc.stopSignalDetection", args);
        } catch (Exception e) {

        }
    }

    private void startMonitoringSearch() {
        mStarted = true;
        DtvkitGlueClient.getInstance().registerSignalHandler(mHandler);
        mTimer = new Timer();
        if (null != mTimer) {
            mTimer.scheduleAtFixedRate(new StatusTimerTask(), 0, 1000);
        }
    }

    private void stopMonitoringSearch() {
        if (null != mTimer) {
            mTimer.cancel();
            mTimer = null;
        }
        DtvkitGlueClient.getInstance().unregisterSignalHandler(mHandler);
        mStarted = false;
    }
}
