package org.dtvkit.inputsource;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;

import java.lang.Integer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class TransportManager {
    private static final String TAG = "TransportManager";
    private static final boolean DEBUG = false;
    private static final int MAX_TRANSPORTS = 4;  // 4 tuners
    
    // HashMap<((onid<<16)| tsid), count>
    private final HashMap<Integer, Integer> mTransports = new HashMap<Integer, Integer>();
    
    public TransportManager() {
    
    }
    
    public int getNumberOfTransports() {
        return (mTransports != null) ? mTransports.size() : 0;
    }
    
    public boolean allocate(int onid, int tsid) {
        Integer key = Integer.valueOf((onid << 16) | tsid);
        Integer value;
        int count = 0;
        boolean ret = false;

        synchronized (mTransports) {
            if (mTransports.size() < MAX_TRANSPORTS) {
                value = mTransports.get(key);
                if (null != value) {
                    count = value.intValue();
                    count ++;
                }
                else {
                    count = 1;
                }
            }
            else {
                value = mTransports.get(key);
                if (null != value) {
                    count = value.intValue();
                    count ++;
                }
            }
            if (count != 0) {
                value = Integer.valueOf(count);
                mTransports.put(key, value);
                ret= true;
            }
        }  // synchronized (mTransports)
        
        return ret;
    }

    public boolean release(int onid, int tsid) {
        Integer key = Integer.valueOf((onid << 16) | tsid);
        Integer value;
        boolean ret = false;

        synchronized (mTransports) {
            value = mTransports.get(key);
            if (null != value) {
                int count = value.intValue();
                count --;
                if (count > 0) {
                    value = Integer.valueOf(count);
                    mTransports.put(key, value);
                }
                else {
                    mTransports.remove(key);
                }
                ret = true;
            }
        }  // synchronized (mTransports)
        
        return ret; 
    }
}
