/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dtvkit.inputsource.player;

import android.annotation.IntDef;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.PowerManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import android.util.Pair;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.widget.VideoView;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaDrm;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.media.MediaTimeProvider;
import android.media.PlaybackParams;
import android.media.SubtitleController;
import android.media.SubtitleController.Anchor;
import android.media.SubtitleData;
import android.media.SubtitleTrack.RenderingWidget;
import android.media.SyncParams;

import com.android.internal.util.Preconditions;

import libcore.io.IoBridge;
import libcore.io.Streams;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.Runnable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;

import org.dtvkit.companionlibrary.TvPlayer;


public class TvMediaPlayer extends MediaPlayer implements TvPlayer
{
    private final static String TAG = "TvMediaPlayer";
    private TvMediaPlayer mPlayer;
    private final List<TvPlayer.Callback> mTvPlayerCallbacks;

    public TvMediaPlayer() {
        mPlayer = null;
        mTvPlayerCallbacks = new CopyOnWriteArrayList<>();
    }

    @Override
    public int getCurrentPosition() {
        if (null != mPlayer) {
            return super.getCurrentPosition();
        }

        return 0;
    }

    /** @return The total length of the currently loaded video in milliseconds. */
    @Override
    public int getDuration() {
        if (null != mPlayer) {
            return super.getDuration();
        }

        return 0;
    }

    @Override
    public void seekTo (int msec) {
        this.seekTo((long)msec);
    }

    @Override
    public void seekTo (long msec, int mode) {
        if (null != mPlayer) {
            super.seekTo(msec, mode);
            return;
        }

        return;
    }

// -------------------------------------------------------------------------
    /**
     * Sets the current position for the current media.
     *
     * @param position The current time in milliseconds to play the media.
     */
    @Override
    public void seekTo(long positionMs) {
        this.seekTo(positionMs, MediaPlayer.SEEK_PREVIOUS_SYNC);
    }

    /**
     * Sets the playback params for the current media.
     *
     * @param params The new playback params.
     */
    @Override
    public void setPlaybackParams(PlaybackParams params) {
        if (null != mPlayer) {
            super.setPlaybackParams(params);
            return;
        }
            
    }


    /** @return The current time in milliseconds of the media. */
    @Override
    public long getCurrentPosition(int nouse) {
        return getCurrentPosition();
    }

    /** @return The total length of the currently loaded video in milliseconds. */
    @Override
    public long getDuration(int nouse) {
        return getDuration();
    }

    /**
     * Sets the surface for the current media.
     *
     * @param surface The surface to play media on
     */
    @Override
    public void setSurface(Surface surface) {
        if (null != mPlayer) {
            super.setSurface(surface);
            return;
        }

        return;
    }

    /**
     * Sets the volume for the current media.
     *
     * @param volume The volume between 0 and 1 to play the media at.
     */
    @Override
    public void setVolume(float volume) {
        if (null != mPlayer) {
            super.setVolume(volume, volume);
            return;
        }

        return;
    }

    /** Pause the current media. */
    @Override
    public void pause() {
        if (null != mPlayer) {
            super.pause();
            return;
        }

        return;
    }

    /** Start playing or resume the current media. */
    @Override
    public void play() {
        if (null != mPlayer) {
            super.start();
            return;
        }
    }

    @Override
    public void registerCallback(TvPlayer.Callback callback) {
        mTvPlayerCallbacks.add(callback);
    }

    @Override
    public void unregisterCallback(TvPlayer.Callback callback) {
        mTvPlayerCallbacks.remove(callback);
    }
}
