#include "DTVKit.h"
#include <utils/Log.h>
#include <json/json.h>
#include <json/writer.h>
#include <iostream>
#include <sstream>
#include <string>

#include "Glue.h"
#include "RequestDataJSON.h"
#include "ResponseDataJSON.h"

#include <log/log.h>
#include <gui/bufferqueue/1.0/H2BGraphicBufferProducer.h>
#include <gui/Surface.h>
#include <system/window.h>

#include "rtk_hal_base.h"
#include "realtek_player.h"

using namespace android;
using ::android::hardware::graphics::bufferqueue::V1_0::utils::H2BGraphicBufferProducer;

extern void ServiceRegisterSignalHandler(const android::sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitSignalHandler>& signalHandler);
extern void ServiceUnegisterSignalHandler(const android::wp<android::hidl::base::V1_0::IBase>& signalHandler);

#define BINDER_BYTES_MAX (256 * 1024)

static std::list<sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitOverlayTarget>> m_overlaytargets;
extern "C" void BinderService_OverlayCreate(int width, int height)
{
   for (std::list<sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitOverlayTarget>>::iterator it = m_overlaytargets.begin();
      it != m_overlaytargets.end(); ++it)
   {
      (*it)->overlayCreate(width, height);
   }
}

extern "C" void BinderService_OverlayDraw(int src_width, int src_height, int dst_x, int dst_y, int dst_width,
   int dst_height, const unsigned char *data)
{
   for (std::list<sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitOverlayTarget>>::iterator it = m_overlaytargets.begin();
      it != m_overlaytargets.end(); ++it)
   {
      (*it)->regionCreate(src_width, src_height);
      int32_t chunk = BINDER_BYTES_MAX / (src_width * 4);
      for (int32_t i = 0; i < src_height; i += chunk)
      {
         int32_t height;

         if ((src_height - i) < chunk)
         {
            height = (src_height - i);
         }
         else
         {
            height = chunk;
         }

         if (((src_height * src_width * 4) - (i * src_width * 4)) < BINDER_BYTES_MAX)
         {
            uint8_t buffer[BINDER_BYTES_MAX] = {0};
            memcpy(buffer, ((const uint8_t *)data) + (i * src_width * 4), height * src_width * 4);
            android::hardware::hidl_array<uint8_t, BINDER_BYTES_MAX> ha(buffer);
            (*it)->regionDrawBitmap(0, i, src_width, height, ha);
         }
         else
         {
            android::hardware::hidl_array<uint8_t, BINDER_BYTES_MAX> ha(((const uint8_t *)data) + (i * src_width * 4));
            (*it)->regionDrawBitmap(0, i, src_width, height, ha);
         }
      }
      (*it)->overlayDrawRegion(dst_x, dst_y, dst_width, dst_height);
   }
}

extern "C" void BinderService_OverlayDisplay()
{
   for (std::list<sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitOverlayTarget>>::iterator it = m_overlaytargets.begin();
      it != m_overlaytargets.end(); ++it)
   {
      (*it)->overlayDisplay();
   }
}

namespace vendor {
namespace dtvkit {
namespace hardware {
namespace dtvkit {
namespace V1_0 {
namespace implementation {

struct SignalHandlerDeathRecipient : virtual public android::hardware::hidl_death_recipient
{
   virtual void serviceDied(uint64_t cookie, const android::wp<android::hidl::base::V1_0::IBase>& who) override
   {
      ServiceUnegisterSignalHandler(who);
   }
};

static sp<SignalHandlerDeathRecipient> g_signal_handler_death_recipient = nullptr;

static bool ParseResource(const std::string &resource, std::string *interface, std::string *invokable)
{
   std::istringstream iss(resource);

   if (interface && invokable)
   {
      std::getline(iss, *interface, '.');
      std::getline(iss, *invokable, '.');
      return (*interface != "" && *invokable != "");
   }

   return false;
}

// Methods from ::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKit follow.
Return<void> DTVKit::request(const hidl_string& resource, const hidl_string& json, request_cb _hidl_cb) {
   //printf("%s // %s\n", resource.c_str(), json.c_str());

   Json::Value response(Json::objectValue);
   response["accepted"] = false;
   response["data"] = "Bad request";

   std::string interface;
   std::string invokable;
   if (ParseResource(resource.c_str(), &interface, &invokable))
   {
      Json::Reader reader;
      Json::Value request;
      if (reader.parse(json.c_str(), request) && request.isArray())
      {
         RequestDataJSON request_data(request);
         ResponseDataJSON response_data(&response["data"]);
         response["accepted"] = Glue::invoke(interface, invokable, &request_data, &response_data);
         response_data.finish();
      }
   }

   Json::FastWriter writer;
   std::string reply(writer.write(response));
   hidl_string result(reply.c_str());
   _hidl_cb(result);
   return Void();
}

Return<void> DTVKit::registerSignalHandler(const sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitSignalHandler>& signalHandler) {
   ServiceRegisterSignalHandler(signalHandler);
   if (g_signal_handler_death_recipient == nullptr)
   {
      g_signal_handler_death_recipient = new SignalHandlerDeathRecipient();
   }
   signalHandler->linkToDeath(g_signal_handler_death_recipient, 1234);

   return Void();
}

Return<void> DTVKit::registerOverlayTarget(const sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitOverlayTarget>& overlayTarget) {
    m_overlaytargets.push_back(overlayTarget);
    return Void();
}

Return<int32_t> DTVKit::setVideoSurface(int32_t type, const sp<::android::hardware::graphics::bufferqueue::V1_0::IGraphicBufferProducer>& gbp, bool is_pip) {
	//ALOGD(LOG_TAG " %d.setVideoSurface(): type = %d, gbp = %p, is_pip = %d.", __LINE__, type, gbp.get(), is_pip);
	sp<::android::IGraphicBufferProducer> iGbp = new H2BGraphicBufferProducer(gbp);
	sp<Surface> surface = new Surface(iGbp);
	RTK_WinPlane  plane_id = (!is_pip) ? RTK_WIN_MAIN : RTK_WIN_PIP;
	
	if(type == 3 /*OTT_TYPE*/)
	{
		if(RT_setVideoSurface(plane_id, NULL) != RTK_OK)
		{
			return -1;
		}
	}
	else
	{
		if((gbp != NULL)  && (surface != NULL))
		{
			sp<ANativeWindow>  nativeWindow(surface);
			if(RT_setVideoSurface(plane_id, nativeWindow.get()) != RTK_OK)
			{
				return -1;
			}
		}
		else
		{
			if(RT_setVideoSurface(plane_id, NULL) != RTK_OK)
			{
				return -2;
			}
		}
	}

	return 0;
}

// Methods from ::android::hidl::base::V1_0::IBase follow.

//IDTVKit* HIDL_FETCH_IDTVKit(const char* /* name */) {
    //return new DTVKit();
//}
//
}  // namespace implementation
}  // namespace V1_0
}  // namespace dtvkit
}  // namespace hardware
}  // namespace dtvkit
}  // namespace vendor

