#ifndef VENDOR_DTVKIT_HARDWARE_DTVKIT_V1_0_DTVKIT_H
#define VENDOR_DTVKIT_HARDWARE_DTVKIT_V1_0_DTVKIT_H

#include <vendor/dtvkit/hardware/dtvkit/1.0/IDTVKit.h>
#include <hidl/MQDescriptor.h>
#include <hidl/Status.h>

namespace vendor {
namespace dtvkit {
namespace hardware {
namespace dtvkit {
namespace V1_0 {
namespace implementation {

using ::android::hardware::hidl_array;
using ::android::hardware::hidl_memory;
using ::android::hardware::hidl_string;
using ::android::hardware::hidl_vec;
using ::android::hardware::Return;
using ::android::hardware::Void;
using ::android::sp;

struct DTVKit : public IDTVKit {
    // Methods from ::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKit follow.
    Return<void> request(const hidl_string& resource, const hidl_string& json, request_cb _hidl_cb) override;
    Return<void> registerSignalHandler(const sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitSignalHandler>& signalHandler) override;
    Return<void> registerOverlayTarget(const sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitOverlayTarget>& overlayTarget) override;

    Return<int32_t> setVideoSurface(int32_t type, const sp<::android::hardware::graphics::bufferqueue::V1_0::IGraphicBufferProducer>& surface, bool is_pip) override;

    // Methods from ::android::hidl::base::V1_0::IBase follow.

};

// FIXME: most likely delete, this is only for passthrough implementations
// extern "C" IDTVKit* HIDL_FETCH_IDTVKit(const char* name);

}  // namespace implementation
}  // namespace V1_0
}  // namespace dtvkit
}  // namespace hardware
}  // namespace dtvkit
}  // namespace vendor

#endif  // VENDOR_DTVKIT_HARDWARE_DTVKIT_V1_0_DTVKIT_H
