#ifndef VENDOR_DTVKIT_HARDWARE_DTVKIT_V1_0_DTVKITOVERLAYTARGET_H
#define VENDOR_DTVKIT_HARDWARE_DTVKIT_V1_0_DTVKITOVERLAYTARGET_H

#include <vendor/dtvkit/hardware/dtvkit/1.0/IDTVKitOverlayTarget.h>
#include <hidl/MQDescriptor.h>
#include <hidl/Status.h>

namespace vendor {
namespace dtvkit {
namespace hardware {
namespace dtvkit {
namespace V1_0 {
namespace implementation {

using ::android::hardware::hidl_array;
using ::android::hardware::hidl_memory;
using ::android::hardware::hidl_string;
using ::android::hardware::hidl_vec;
using ::android::hardware::Return;
using ::android::hardware::Void;
using ::android::sp;

struct DTVKitOverlayTarget : public IDTVKitOverlayTarget {
    // Methods from ::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitOverlayTarget follow.
    Return<void> regionCreate(int32_t width, int32_t height) override;
    Return<void> regionDrawBitmap(int32_t x, int32_t y, int32_t width, int32_t height, const hidl_array<uint8_t, 262144>& data) override;
    Return<void> overlayCreate(int32_t width, int32_t height) override;
    Return<void> overlayDrawRegion(int32_t x, int32_t y, int32_t width, int32_t height) override;
    Return<void> overlayDisplay() override;

    // Methods from ::android::hidl::base::V1_0::IBase follow.

};

// FIXME: most likely delete, this is only for passthrough implementations
// extern "C" IDTVKitOverlayTarget* HIDL_FETCH_IDTVKitOverlayTarget(const char* name);

}  // namespace implementation
}  // namespace V1_0
}  // namespace dtvkit
}  // namespace hardware
}  // namespace dtvkit
}  // namespace vendor

#endif  // VENDOR_DTVKIT_HARDWARE_DTVKIT_V1_0_DTVKITOVERLAYTARGET_H

