#ifndef CASINTERFACE_H
#define CASINTERFACE_H

#include <iostream>

#include "Glue.h"
#include "RequestData.h"
#include "ResponseData.h"

#include "Rtk_CDCa.h"

/**
 * @ingroup metaapi
 * @defgroup casmetaapi Cas Meta-API
 * Dvb
 */

class CasInterface: public Glue::Interface
{
protected:
    // CDCAS
    struct ActionRequestExt
    {
		CDCA_U16 wTVSID;
        CDCA_U8  byActionType;
        CDCA_U8 byLen;
        CDCA_U8* pbyData;
    };

    struct ContinuesWatchLimit
    {
		CDCA_U8 byType;
        CDCA_U16 wWorkTime;
        CDCA_U16 wStopTime;
    };

    struct DetitleReceived
    {
        CDCA_U8 bstatus;
    };

    struct EntitleChanged
    {
        CDCA_U16 wTvsID;
    };

    struct EmailNotifyIcon
    {
        CDCA_U8 byShow;
        CDCA_U32 dwEmailID;
    };

    struct HideIPPVDlg
    {
        CDCA_U16 wEcmPid;
    };

    struct HideOSDMessage
    {
        CDCA_U8 byStyle;
    };

    struct LockService
    {
        const SCDCALockService * pLockService;
    };

    struct RequestFeeding
    {
        CDCA_BOOL bReadStatus;
    };

    struct ShowBuyMessage
    {
        CDCA_U16 wEcmPID;
        CDCA_U8 byMessageType;
    };

    struct ShowCurtainNotify
    {
        CDCA_U16 wEcmPID;
        CDCA_U16 wCurtainCode;
    };

    struct ShowFingerInfo
    {
        CDCA_U16 wEcmPID;
        const SCDCAFingerInfo * pFingerInfo;
    };

    struct ShowFingerMessageExt
    {
        CDCA_U16 wEcmPID;
        char * fingerMsg;
    };

    struct ShowOSDInfo
    {
        SCDCAOSDInfo *pOSDInfo;
    };

    struct ShowOSDMessage
    {
        CDCA_U8 byStyle;
        const char * szMessage;
    };

    struct ShowProgressStrip
    {
        CDCA_U8 byProgress;
        CDCA_U8 byMark;
    };

    struct StartIppvBuyDlg
    {
        CDCA_U8 byMessageType;
        CDCA_U16 wEcmPid;
        const SCDCAIppvBuyInfo * pIppvProgram;
    };

public:
   static CasInterface& instance()
   {
      static CasInterface instance;
      return instance;
   }

   static void postEvent(unsigned int code, const void *data, unsigned int data_size)
   {
      instance().event(code, data, data_size);
   }

   /*------- 智能卡管理 -------*/

   bool changePin(RequestData* request, ResponseData* response);
   bool delDetitleChkNum(RequestData* request, ResponseData* response);
   bool delEmail(RequestData* request, ResponseData* response);
   bool formatBuffer(RequestData* request, ResponseData* response);
   bool getACList(RequestData* request, ResponseData* response);
   bool getCardFreezeStatus(RequestData* request, ResponseData* response);

   /* 读取智能卡外部卡号 */
   bool getCardSN(RequestData* request, ResponseData* response);
   bool getCardVer(RequestData* request, ResponseData* response);
   bool getDetitleChkNums(RequestData* request, ResponseData* response);
   bool getDetitleReaded(RequestData* request, ResponseData* response);
   bool getEmailContent(RequestData* request, ResponseData* response);
   bool getEmailHead(RequestData* request, ResponseData* response);
   bool getEmailHeads(RequestData* request, ResponseData* response);
   bool getEmailSpaceInfo(RequestData* request, ResponseData* response);
   bool getEntitleIDs(RequestData* request, ResponseData* response);
   bool getOperatorIds(RequestData* request, ResponseData* response);
   bool getOperatorInfo(RequestData* request, ResponseData* response);
   bool getPlatformID(RequestData* request, ResponseData* response);
   bool getRating(RequestData* request, ResponseData* response);
   bool getServiceEntitles(RequestData* request, ResponseData* response);
   bool getSlotIDs(RequestData* request, ResponseData* response);
   bool getSlotInfo(RequestData* request, ResponseData* response);

   /**
    * @ingroup casmetaapi
    * @brief get the STB serial number.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * getSTBSN()
    * ~~~
    * @param response Used to write _status object_ response (example pseudocode):
    * ~~~{.js}
    * {
    * 
    * }
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool getSTBSN(RequestData* request, ResponseData* response);
   bool getTerminalTypeID(RequestData* request, ResponseData* response);
   bool getVer(RequestData* request, ResponseData* response);
   bool getWorkTime(RequestData* request, ResponseData* response);
   bool isPaired(RequestData* request, ResponseData* response);
   bool setRating(RequestData* request, ResponseData* response);
   bool getDrmKey(RequestData* request, ResponseData* response);
   bool refreshInterface(RequestData* request, ResponseData* response);

   // CDCAS callback data
   bool getActionRequestExt(RequestData* request, ResponseData* response);
   bool getContinuesWatchLimit(RequestData* request, ResponseData* response);
   bool getDetitleReceived(RequestData* request, ResponseData* response);
   bool getEntitleChanged(RequestData* request, ResponseData* response);
   bool getEmailNotifyIcon(RequestData* request, ResponseData* response);
   bool getHideIPPVDlg(RequestData* request, ResponseData* response);
   bool getHideOSDMessage(RequestData* request, ResponseData* response);
   bool getLockService(RequestData* request, ResponseData* response);
   bool getRequestFeeding(RequestData* request, ResponseData* response);
   bool getShowBuyMessage(RequestData* request, ResponseData* response);
   bool getShowCurtainNotify(RequestData* request, ResponseData* response);
   bool getShowFingerInfo(RequestData* request, ResponseData* response);
   bool getShowFingerMessageExt(RequestData* request, ResponseData* response);
   bool getShowOSDInfo(RequestData* request, ResponseData* response);
   bool getShowOSDMessage(RequestData* request, ResponseData* response);
   bool getShowProgressStrip(RequestData* request, ResponseData* response);
   bool getStartIppvBuyDlg(RequestData* request, ResponseData* response);
   bool getUNLockService(RequestData* request, ResponseData* response);

   // CDCAS callback
   void onActionRequestExt(CDCA_U16 wTVSID, CDCA_U8  byActionType, CDCA_U8 byLen, CDCA_U8* pbyData);
   void onContinuesWatchLimit(CDCA_U8 byType, CDCA_U16 wWorkTime, CDCA_U16 wStopTime);
   void onDetitleReceived(CDCA_U8 bstatus);
   void onEntitleChanged(CDCA_U16 wTvsID);
   void onEmailNotifyIcon (CDCA_U8 byShow, CDCA_U32 dwEmailID);
   void onHideIPPVDlg(CDCA_U16 wEcmPid);
   void onHideOSDMessage (CDCA_U8 byStyle);
   void onLockService(const SCDCALockService* pLockService);
   void onRequestFeeding(CDCA_BOOL bReadStatus);
   void onShowBuyMessage (CDCA_U16 wEcmPID, CDCA_U8 byMessageType);
   void onShowCurtainNotify(CDCA_U16 wEcmPID, CDCA_U16 wCurtainCode);
   void onShowFingerInfo (CDCA_U16 wEcmPID, const SCDCAFingerInfo* pFingerInfo);
   void onShowFingerMessageExt(CDCA_U16 wEcmPID, char * fingerMsg);
   void onShowOSDInfo(SCDCAOSDInfo *pOSDInfo);
   void onShowOSDMessage (CDCA_U8 byStyle, const char * szMessage);
   void onShowProgressStrip(CDCA_U8 byProgress, CDCA_U8 byMark);
   void onStartIppvBuyDlg(CDCA_U8 byMessageType, CDCA_U16 wEcmPid, const SCDCAIppvBuyInfo* pIppvProgram);
   void onUNLockService (void);

private:
   CasInterface();
   CasInterface(CasInterface const&);
   CasInterface& operator=(CasInterface const&);
   void event(unsigned int code, const void *data, unsigned int data_size);

protected:
   Rtk_CDCA * mCasInstance;
   //
   ActionRequestExt mActionRequestExt;
   ContinuesWatchLimit mContinuesWatchLimit;
   DetitleReceived mDetitleReceived;
   EntitleChanged mEntitleChanged;
   EmailNotifyIcon mEmailNotifyIcon;
   HideIPPVDlg mHideIPPVDlg;
   HideOSDMessage mHideOSDMessage;
   LockService mLockService;
   RequestFeeding mRequestFeeding;
   ShowBuyMessage mShowBuyMessage;
   ShowCurtainNotify mShowCurtainNotify;
   ShowFingerInfo mShowFingerInfo;
   ShowFingerMessageExt mShowFingerMessageExt;
   ShowOSDInfo mShowOSDInfo;
   ShowOSDMessage mShowOSDMessage;
   StartIppvBuyDlg mStartIppvBuyDlg;
   ShowProgressStrip mShowProgressStrip;
};

#endif // CASINTERFACE_H

