#ifndef DVBCINTERFACE_H
#define DVBCINTERFACE_H

#include <iostream>

#include "Glue.h"
#include "RequestData.h"
#include "ResponseData.h"

/**
 * @ingroup metaapi
 * @defgroup dvbcmetaapi DVB-C Meta-API
 * Dvb
 */

class DvbcInterface: public Glue::Interface
{
   public:
   static DvbcInterface& instance()
   {
      static DvbcInterface instance;
      return instance;
   }

   /**
    * @ingroup dvbcmetaapi
    * @brief Get status.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * getStatus()
    * ~~~
    * @param response Used to write _status object_ response (example pseudocode):
    * ~~~{.js}
    * {
    *    "frontendpath": 0,
    *    "progress": 70,
    *    "started": true
    * }
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool getStatus(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbcmetaapi
    * @brief Get signal quality.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * getSignalStatus()
    * ~~~
    * @param response Used to write _status object_ response (example pseudocode):
    * ~~~{.js}
    * {
    *    "frontendpath": 0,
    *    "progress": 70,
    *    "started": true
    * }
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool getSignalStatus(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbcmetaapi
    * @brief Start search. Signals DvbcStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * startSearch(clear_old_search = false)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool startSearch(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbcmetaapi
    * @brief Start manual search. Signals DvbcStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * startManualSearch(network = false, frequency = 0, modulation = "auto", symbol_rate = 0, clear_old_search = false)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool startManualSearch(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbcmetaapi
    * @brief Finish search. Signals DvbcStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * finishSearch(commit = true)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool finishSearch(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbcmetaapi
    * @brief Start signal detection. Signals DvbcStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * startSignalDetection(frequency = 0, modulation = "auto", symbol_rate = 0)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool startSignalDetection(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbcmetaapi
    * @brief stop signal detection. Signals DvbcStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * stopSignalDetection(commit = true)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool stopSignalDetection(RequestData* request, ResponseData* response);

   private:
	DvbcInterface();
   DvbcInterface(DvbcInterface const&);
   DvbcInterface& operator=(DvbcInterface const&);

   static void eventHandler(unsigned int code, const void *data, unsigned int data_size);
};

#endif // DVBCINTERFACE_H

