#ifndef DVBSINTERFACE_H
#define DVBSINTERFACE_H

#include <iostream>

#include "Glue.h"
#include "RequestData.h"
#include "ResponseData.h"

/**
 * @ingroup metaapi
 * @defgroup dvbsmetaapi DVB-S Meta-API
 * Dvb
 */

class DvbsInterface: public Glue::Interface
{
   public:
   static DvbsInterface& instance()
   {
      static DvbsInterface instance;
      return instance;
   }

   /**
    * @ingroup dvbsmetaapi
    * @brief Get status.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * getStatus()
    * ~~~
    * @param response Used to write _status object_ response (example pseudocode):
    * ~~~{.js}
    * {
    *    "frontendpath": 0,
    *    "progress": 70,
    *    "started": true
    * }
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool getStatus(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbsmetaapi
    * @brief Start search. Signals DvbsStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * startSearch(clear_old_search = false)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool startSearch(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbsmetaapi
    * @brief Start manual search. Signals DvbsStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * startManualSearch(network = false, frequency = 0, satellite = "default", polarity = "horizontal", symbol_rate = 0,
    *    fec = "auto", dvbs2 = true, modulation = "auto", clear_old_search = false)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool startManualSearch(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbsmetaapi
    * @brief Finish search. Signals DvbsStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * finishSearch(commit = true)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool finishSearch(RequestData* request, ResponseData* response);

   private:
	DvbsInterface();
   DvbsInterface(DvbsInterface const&);
   DvbsInterface& operator=(DvbsInterface const&);

   static void eventHandler(unsigned int code, const void *data, unsigned int data_size);
};

#endif // DVBSINTERFACE_H

