#ifndef DVBTINTERFACE_H
#define DVBTINTERFACE_H

#include <iostream>

#include "Glue.h"
#include "RequestData.h"
#include "ResponseData.h"

/**
 * @ingroup metaapi
 * @defgroup dvbtmetaapi DVB-T Meta-API
 * Dvb
 */

class DvbtInterface: public Glue::Interface
{
   public:
   static DvbtInterface& instance()
   {
      static DvbtInterface instance;
      return instance;
   }

   /**
    * @ingroup dvbtmetaapi
    * @brief Get status.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * getStatus()
    * ~~~
    * @param response Used to write _status object_ response (example pseudocode):
    * ~~~{.js}
    * {
    *    "frontendpath": 0,
    *    "progress": 70,
    *    "started": true
    * }
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool getStatus(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbtmetaapi
    * @brief Start search. Signals DvbtStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * startSearch(clear_old_search = false)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool startSearch(RequestData* request, ResponseData* response);

   /**
    * @ingroup dvbtmetaapi
    * @brief Finish search. Signals DvbtStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * finishSearch(save_changes = true)
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool finishSearch(RequestData* request, ResponseData* response);

   private:
	DvbtInterface();
   DvbtInterface(DvbtInterface const&);
   DvbtInterface& operator=(DvbtInterface const&);

   static void eventHandler(unsigned int code, const void *data, unsigned int data_size);
};

#endif // DVBTINTERFACE_H

