#ifndef RECORDERINTERFACE_H
#define RECORDERINTERFACE_H

#include <iostream>

#include "Glue.h"
#include "RequestData.h"
#include "ResponseData.h"

/**
 * @ingroup metaapi
 * @defgroup recordermetaapi Player Meta-API
 * Dvb
 */

class RecorderInterface: public Glue::Interface
{
   public:
   static RecorderInterface& instance()
   {
      static RecorderInterface instance;
      return instance;
   }

   static void postEvent(unsigned int code, const void *data, unsigned int data_size)
   {
      instance().event(code, data, data_size);
   }

   /**
    * @ingroup recordermetaapi
    * @brief Get status.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * getStatus()
    * ~~~
    * @param response Used to write _status object_ response (example pseudocode):
    * ~~~{.js}
    * {
    *    "frontendpath": 0,
    *    "state": "playing",
    *    "type": "live",
    *    "uri": "dvb://233a.4000.41c0"
    * }
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool getStatus(RequestData* request, ResponseData* response);

   /**
    * @ingroup recordermetaapi
    * @brief Get SSU status.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * getStatus()
    * ~~~
    * @param response Used to write _status object_ response (example pseudocode):
    * ~~~{.js}
    * {
    *    "release":"HCA5821191021.1",
    *    "uri": null
    * }
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool getSsuStatus(RequestData* request, ResponseData* response);


   /**
    * @ingroup recordermetaapi
    * @brief Tune content _uri_.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * tune(uri = "")
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool tune(RequestData* request, ResponseData* response);

   /**
    * @ingroup recordermetaapi
    * @brief Start recording program _uri_. Signals PlayerStatusChanged with getStatus data.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * start(uri = "")
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * true
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool startRecording(RequestData* request, ResponseData* response);

   /**
    * @ingroup recordermetaapi
    * @brief Stop recording program.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * stop()
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * stop
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool stopRecording(RequestData* request, ResponseData* response);

   /**
    * @ingroup recordermetaapi
    * @brief release.
    * @param request Used to read arguments for the invokable (pseudocode):
    * ~~~{.java}
    * stop()
    * ~~~
    * @param response Used to write _success bool_ response (example pseudocode):
    * ~~~{.js}
    * stop
    * ~~~
    * @return Success (on failure, an error string is written to response)
    */
   bool release(RequestData* request, ResponseData* response);

   private:
   RecorderInterface();
   RecorderInterface(RecorderInterface const&);
   RecorderInterface& operator=(RecorderInterface const&);
   void event(unsigned int code, const void *data, unsigned int data_size);
};

#endif // RecorderInterface_H

