#ifndef __ANDROID__LOG_H__
#define __ANDROID__LOG_H__

#define TAG	"DtvkitPlayerInterface"

#ifdef __ANDROID__
#include <android/log.h>
#define LOGV(...) ((void)__android_log_print(ANDROID_LOG_VERBOSE, TAG, __VA_ARGS__))
#ifdef BUILD_RELEASE
#define LOGD(...) 
#else
#define LOGD(...) ((void)__android_log_print(ANDROID_LOG_DEBUG, TAG, __VA_ARGS__))
#endif
#define LOGI(...) ((void)__android_log_print(ANDROID_LOG_INFO, TAG, __VA_ARGS__))
#define LOGW(...) ((void)__android_log_print(ANDROID_LOG_WARN, TAG, __VA_ARGS__))
#define LOGE(...) ((void)__android_log_print(ANDROID_LOG_ERROR, TAG, __VA_ARGS__))

#else
#define LOGV(fmt, arg...) printf("V/"TAG": " fmt, ##arg)
#ifdef BUILD_RELEASE
#define LOGD(fmt, arg...) 
#else
#define LOGD(fmt, arg...) printf("D/"TAG": " fmt, ##arg)
#endif
#define LOGI(fmt, arg...) printf("I/"TAG": " fmt, ##arg)
#define LOGW(fmt, arg...) printf("W/"TAG": " fmt, ##arg)
#define LOGE(fmt, arg...) fprintf(stderr, "E/"TAG": " fmt, ##arg)
#endif /* #ifdef __ANDROID__ */

#endif /* #ifndef __ANDROID__LOG_H__ */
