#include <string>

#include "ResponseData.h"
#include "common.h"
#include <cstdio>
#include <iostream>

#include "Entities.h"

#define UTF8_HEADER_VALUE 0x15

Entities::ContentSource Entities::getContentSource(std::string uri)
{
   if (Entities::getServiceHandle(uri))
   {
      return Entities::ContentSourceDvbLive;
   }
   else
   {
      size_t found = uri.find_first_of("://");
      std::string scheme = uri.substr(0,found);
      if ("crid" == scheme) {
          return Entities::ContentSourceTimeShift;
      }

      return Entities::ContentSourceNull;
   }
}

void * Entities::getServiceHandle(std::string uri)
{
   void *handle = NULL;
   U16BIT onet_id;
   U16BIT trans_id;
   U16BIT serv_id;
   if (uri == "dvb://current")
   {
      U8BIT livedecodepath = STB_DPGetLivePath();
      if (livedecodepath != INVALID_RES_ID)
      {
         handle = ADB_GetTunedService(livedecodepath);
      }
   }
   else if (std::sscanf(uri.c_str(), "dvb://%04hx.%04hx.%04hx", &onet_id, &trans_id, &serv_id) == 3)
   {
      handle = ADB_FindServiceByIds(onet_id, trans_id, serv_id);
   }

   return handle;
}

void * Entities::getEventHandle(std::string uri)
{
   void *handle = NULL;
   U16BIT onet_id;
   U16BIT trans_id;
   U16BIT serv_id;
   U16BIT event_id;
   if (std::sscanf(uri.c_str(), "dvb://%04hx.%04hx.%04hx;%04hx", &onet_id, &trans_id, &serv_id, &event_id) == 4)
   {
      if ((handle = ADB_FindServiceByIds(onet_id, trans_id, serv_id)))
      {
         handle = ADB_GetEvent(handle, event_id);
      }
   }

   return handle;
}

void Entities::deleteEventHandle(void *handle)
{
   if (handle)
   {
      ADB_ReleaseEventData(handle);
   }
}

std::string Entities::getServiceUri(const void *chandle)
{
   std::string uri;

   void *handle = const_cast<void *>(chandle);

   U16BIT onet_id = 0;
   U16BIT trans_id = 0;
   U16BIT serv_id = 0;
   if (handle)
   {
      ADB_GetServiceIds(handle, &onet_id, &trans_id, &serv_id);
   }

   char string[20 + 1];
   if (snprintf(string, sizeof(string), "dvb://%04hx.%04hx.%04hx", onet_id, trans_id, serv_id) == sizeof(string) - 1)
   {
      uri = string;
   }

   return uri;
}

std::string Entities::getEventUri(const void *chandle)
{
   std::string uri;

   void *handle = const_cast<void *>(chandle);

   U16BIT onet_id = 0;
   U16BIT trans_id = 0;
   U16BIT serv_id = 0;
   U16BIT event_id = 0;
   if (handle)
   {
      void *service = ADB_GetEventService(handle);
      if (service)
      {
         ADB_GetServiceIds(service, &onet_id, &trans_id, &serv_id);
         event_id = ADB_GetEventId(handle);
      }
   }

   char string[25 + 1];
   if (snprintf(string, sizeof(string), "dvb://%04hx.%04hx.%04hx;%04hx", onet_id, trans_id, serv_id, event_id) == sizeof(string) - 1)  
   {
      uri = string;
   }

   return uri;
}

std::string Entities::parseDvbString(const U8BIT *cvalue)
{
   std::string string;
   U8BIT *value = const_cast<U8BIT *>(cvalue);

   if (!value)
   {
      string = "";
   }
   else if (*value != UTF8_HEADER_VALUE)
   {
      U16BIT length;
      if ((value = STB_ConvertStringToUTF8(value, &length, true, 0)))
      {
         string = reinterpret_cast<char *>(value) + 1;
         STB_ReleaseUnicodeString(value);
      }
   }
   else if ((value = STB_UnicodeStripControlChars(value)))
   {
      string = reinterpret_cast<char *>(value) + 1;
      STB_ReleaseUnicodeString(value);
   }

   return string;
}

