#include <string>

#include "ResponseData.h"
#include "common.h"

#include <string>

#define NULL_SERVICE_URI "dvb://0000.0000.0000.0000"
#define NULL_EVENT_URI "dvb://0000.0000.0000.0000;0000"

namespace Entities
{
   enum ContentSource
   {
      ContentSourceNull,
      ContentSourceDvbLive,
      ContentSourceTimeShift
   };

   ContentSource getContentSource(std::string uri);
   void * getServiceHandle(std::string uri);
   void * getEventHandle(std::string uri);
   void deleteEventHandle(void *handle);
   std::string getServiceUri(const void *handle);
   std::string getEventUri(const void *handle);
   std::string parseDvbString(const U8BIT *value);
}

