#ifndef EventManager_H
#define EventManager_H

#include <map>

class EventManager
{
   public:
   typedef void (*EventHandler)(unsigned int code, const void *data, unsigned int data_size);

   /**
    * @brief Add an event handler to the manager that is called for each event.
    * @param handler Pointer to an event handler function.
    */
   static void addEventHandler(EventHandler handler)
   {
      EventManager& manager = instance();
      if (std::find(manager.m_eventhandlers.begin(), manager.m_eventhandlers.end(), handler) == manager.m_eventhandlers.end())
      {
         manager.m_eventhandlers.push_back(handler);
      }
   }

   /**
    * @brief Send event to each event handler.
    */
   static void event(unsigned int code, void *data, unsigned int data_size)
   {
      EventManager& manager = instance();
      for (std::list<EventHandler>::iterator it = manager.m_eventhandlers.begin(); it != manager.m_eventhandlers.end(); ++it)
      {
         (*it)(code, data, data_size);
      }
   }

   private:
	EventManager() {};
   EventManager(EventManager const&);
   EventManager& operator=(EventManager const&);

   static EventManager& instance()
   {
      static EventManager instance;
      return instance;
   }

   std::list<EventHandler> m_eventhandlers;
};

#endif // EventManager_H

