#define LOG_TAG "vendor.dtvkit.hardware.dtvkit@1.0-service"
  
#include <vendor/dtvkit/hardware/dtvkit/1.0/IDTVKit.h>

#include <hidl/LegacySupport.h>

#include "DTVKit.h"

#include "Glue.h"
#include "DvbInterface.h"
#include "DvbtInterface.h"
#include "DvbsInterface.h"
#include "DvbcInterface.h"
#include "PlayerInterface.h"
#include "RecorderInterface.h"
#include "CasInterface.h"

#include <json/json.h>
#include <json/writer.h>
#include <iostream>
#include <sstream>
#include <string>
#include <mutex>
#include "RequestDataJSON.h"
#include "ResponseDataJSON.h"

#ifdef ENABLE_LIBDVBPSI
#include <dvbpsi/dvbpsi.h>
#include <dvbpsi/descriptor.h>
#include <dvbpsi/dr.h>
#include <dvbpsi/nit.h>
#endif

using android::hardware::configureRpcThreadpool;
using android::hardware::joinRpcThreadpool;
using vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKit;
using vendor::dtvkit::hardware::dtvkit::V1_0::implementation::DTVKit;
using namespace android;

static std::list<sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitSignalHandler>> g_signalhandlers;
static std::mutex g_signalhandlers_mutex;

void ServiceRegisterSignalHandler(const sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitSignalHandler>& signalHandler)
{
   std::lock_guard<std::mutex> guard(g_signalhandlers_mutex);

   g_signalhandlers.push_back(signalHandler);
}

void ServiceUnegisterSignalHandler(const android::wp<android::hidl::base::V1_0::IBase>& signalHandler)
{
   std::lock_guard<std::mutex> guard(g_signalhandlers_mutex);

   std::list<sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitSignalHandler>>::iterator it = g_signalhandlers.begin();
   while (it != g_signalhandlers.end())
   {
      if (*it == signalHandler)
      {
         g_signalhandlers.erase(it++);
      }
      else
      {
         ++it;
      }
   }
}

static void SignalHandler(const std::string &signal, Glue::Interface::Invokable invokable, Glue::Interface *invokable_object)
{
   Json::Value message;
   Json::FastWriter writer;

   RequestDataJSON request_data(Json::arrayValue);
   ResponseDataJSON response_data(&message);
   if (invokable && invokable_object)
   {
      (invokable_object->*invokable)(&request_data, &response_data);
   }
   else
   {
      ResponseData::Object *object = response_data.setObject(0);
      object->finish();
   }
   response_data.finish();

   std::string json(writer.write(message));
   std::lock_guard<std::mutex> guard(g_signalhandlers_mutex);
   for (std::list<sp<::vendor::dtvkit::hardware::dtvkit::V1_0::IDTVKitSignalHandler>>::iterator it = g_signalhandlers.begin();
      it != g_signalhandlers.end(); ++it)
   {
      (*it)->signal(signal, json);
   }
}

#ifdef ENABLE_LIBDVBPSI
static void message_callback(void *context, int param)
{
    return;
}

static void dvbpsi_message (
	dvbpsi_t *p_dvbpsi,
	const dvbpsi_msg_level_t level,
	const char* msg )
{
    int code = 0;
    const char *psz_level;
    
    switch(level)
    {
        case DVBPSI_MSG_ERROR:
		code = 0;
		psz_level = "Error: ";
		break;
        case DVBPSI_MSG_WARN:
		code = 1;
		psz_level = "Warning: ";
		break;
        case DVBPSI_MSG_DEBUG:
		code = 3;
		psz_level = "Debug: ";
		break;
        default:
            return;
    }
}
#endif


int main()
{
#ifdef ENABLE_LIBDVBPSI
	dvbpsi_t *dvbpsi_handle;

	dvbpsi_handle = dvbpsi_new(&dvbpsi_message, DVBPSI_MSG_DEBUG);;
	if (dvbpsi_handle == NULL) {
		return -1;
	}
#endif

   configureRpcThreadpool(1, true /*callerWillJoin*/);
   
   volatile DvbInterface & instance = DvbInterface::instance();
   Glue::addInterface<DvbInterface>("Dvb");
   Glue::addInterface<DvbtInterface>("Dvbt");
   Glue::addInterface<DvbsInterface>("Dvbs");
   Glue::addInterface<DvbcInterface>("Dvbc");
   Glue::addInterface<PlayerInterface>("Player");
   Glue::addInterface<RecorderInterface>("Recorder");
   Glue::addInterface<CasInterface>("Cas");
   Glue::addSignalHandler(SignalHandler);

   android::sp<IDTVKit> service = new DTVKit();
   const status_t status = service->registerAsService();
   if (status != ::android::OK) {
      ALOGE("failed to register as service");
      return 1; // or handle error
   }
   // Adds this thread to the threadpool, resulting in one total
   // thread in the threadpool. We could also do other things, but
   // would have to specify 'false' to willJoin in configureRpcThreadpool.
   ::android::hardware::joinRpcThreadpool();
   return 1; // joinRpcThreadpool should never return
}

