/*******************************************************************************
 * Copyright © 2017 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Handset id, codes and front panel events
 * @file    stbhwkey.h
 * @date    February 2009
 */

#ifndef _STBHWKEY_H
#define _STBHWKEY_H


/*--- Includes ----------------------------------------------------------------*/

/*--- Preprocessor definitions ------------------------------------------------*/

#define HANDSET_ID                  0x807F

// handset keycodes...
#define HS_EVENT_STANDBY            0x0081f00f
#define HS_EVENT_MUTE               0x0081f04e
#define HS_EVENT_NUMERIC_1          0x00810031
#define HS_EVENT_NUMERIC_2          0x00810032
#define HS_EVENT_NUMERIC_3          0x00810033
#define HS_EVENT_NUMERIC_4          0x00810034
#define HS_EVENT_NUMERIC_5          0x00810035
#define HS_EVENT_NUMERIC_6          0x00810036
#define HS_EVENT_NUMERIC_7          0x00810037
#define HS_EVENT_NUMERIC_8          0x00810038
#define HS_EVENT_NUMERIC_9          0x00810039
#define HS_EVENT_NUMERIC_0          0x00810030
#define HS_EVENT_EPG                0x0081f01b
#define HS_EVENT_FAV                0x0081f048
#define HS_EVENT_MENU               0x0081f012
#define HS_EVENT_ESC                0x0081f062
#define HS_EVENT_UP                 0x0081f002
#define HS_EVENT_LEFT               0x0081f000
#define HS_EVENT_OK                 0x0081f00b
#define HS_EVENT_RIGHT              0x0081f001
#define HS_EVENT_DOWN               0x0081f003
#define HS_EVENT_SERVICES           0x0081f027
#define HS_EVENT_RED                0x0081f042
#define HS_EVENT_GREEN              0x0081f043
#define HS_EVENT_YELLOW             0x0081f044
#define HS_EVENT_BLUE               0x0081f045
#define HS_EVENT_SUBT               0x0081f020
#define HS_EVENT_CHAN_UP            0x0081f046
#define HS_EVENT_CHAN_DOWN          0x0081f047
#define HS_EVENT_VOL_UP             0x0081f04c
#define HS_EVENT_VOL_DOWN           0x0081f04d
#define HS_EVENT_WIDE               0x0081f027      /* button label: TV/DTV */
#define HS_EVENT_VFORM              0x0081f026      /* button label: TV/Format */
#define HS_EVENT_TEXT               0x0081f032
#define HS_EVENT_LANG               0x0081f037
#define HS_EVENT_AD                 0x0081f064

#define HS_EVENT_AV_SOURCE          0x0081005a      /* No key available for this on NXP remote */

#define HS_EVENT_FUNC_PLS           0x00810053
#define HS_EVENT_INFO               0x0081f014
#define HS_EVENT_RECALL             0x0081f105      /* button label: <- -> */
#define HS_EVENT_PAUSE              0x0081f00a      /* no button assigned */
#define HS_EVENT_TIMER              0x0081f015
#define HS_EVENT_PROG_TIMER         HS_EVENT_TIMER
#define HS_EVENT_F1                 0x0081ffff
#define HS_EVENT_F2                 0x0081fffe
#define HS_EVENT_TVRAD              0x0081fffd

// extra codes for DVD...
#define HS_EVENT_PREV               0x00810010
#define HS_EVENT_REV_SCAN           0x0081004E
#define HS_EVENT_FWD_SCAN           0x0081004D
#define HS_EVENT_NEXT               0x00810008
#define HS_EVENT_TITLE_MENU         0x0081001F
#define HS_EVENT_SETUP              0x00810043
#define HS_EVENT_DISPLAY            0x00810017
#define HS_EVENT_RETURN             0x00810056
#define HS_EVENT_STEP_FWD           0x0081f05c
#define HS_EVENT_SLOW_FWD           0x0081000E
#define HS_EVENT_ANGLE              0x0081000F
#define HS_EVENT_3D                 0X0081004b
#define HS_EVENT_AUDIO              0X00810050
#define HS_EVENT_GOTO               0x0081004C
#define HS_EVENT_RPT                0x0081004F
#define HS_EVENT_RPT_AB             0x00810001
#define HS_EVENT_BOOKMARK           0X00810054
#define HS_EVENT_MODE               0X0081fffc
#define HS_EVENT_FF                 0x0081f05a
#define HS_EVENT_FR                 0x0081f059
#define HS_EVENT_SKIP_FORWARD       0x0081f05c
#define HS_EVENT_SKIP_BACK          0x0081f05b

#define HS_EVENT_DEFINE_BOOKMARK    0x0081FFFF
#define HS_EVENT_NEXT_BOOKMARK      0x0081FFFE
#define HS_EVENT_REC                0x0081f056
#define HS_EVENT_PLAY               0x0081f051
#define HS_EVENT_STOP               0x0081f052
#define HS_EVENT_STEPF              HS_EVENT_PAUSE
#define HS_EVENT_SM                 0x0081004b
#define HS_EVENT_SLOWF              HS_EVENT_SM
#define HS_EVENT_QR                 0x0081004e
#define HS_EVENT_JTL                0x0081004f

/* Keycodes for Freesat/Saorview RCU */
#define HS_EVENT_TVGUIDE       		HS_EVENT_EPG
#define HS_EVENT_HOME          		HS_EVENT_MENU
#define HS_EVENT_EXIT          		HS_EVENT_ESC
#define HS_EVENT_RECORDINGS    		0x0081f101
#define HS_EVENT_SEARCH        		0x0081f103
#define HS_EVENT_SETTINGS      		0x0081bb44
#define HS_EVENT_ONDEMAND      		0x0081f104
#define HS_EVENT_SHOWCASE      		0x0081f102
#define HS_EVENT_BACK          		0x0081f048
#define HS_EVENT_LIST          		0x0081fffe

/* Front panel keypad events */
#define KP_EVENT_STANDBY            0x0082007f
#define KP_EVENT_MENU               0x0082016c
#define KP_EVENT_VOL_DOWN           0x00820165
#define KP_EVENT_VOL_UP             0x00820166
#define KP_EVENT_CHAN_UP            0x00820167
#define KP_EVENT_CHAN_DOWN          0x00820168
#define KP_EVENT_OK                 0x00820169
#define KP_EVENT_AV_SOURCE          0x0082016a
#define KP_EVENT_LEFT               0x0082016d
#define KP_EVENT_RIGHT              0x0082016e

/* Kim added */
#define HS_EVENT_A                  0x00810061
#define HS_EVENT_B                  0x00810062
#define HS_EVENT_C                  0x00810063
#define HS_EVENT_D                  0x00810064


/*--- Global types definitions ------------------------------------------------*/

/*--- Global function declarations --------------------------------------------*/


#endif /* _STBHWKEY_H */


/****************************************************************************
** End of file
*****************************************************************************/
