#include "stbhwc.h"
#include "stbhwsdk.h"

// Serial port functions

void STB_SPWrite(U8BIT *data, U32BIT len, U32BIT timeout, U32BIT *written)
{

}

void STB_SPRead(U8BIT *data, U32BIT len, U32BIT timeout, U32BIT *read)
{

}

#if 0
/**
 * @brief   Write debug string to serial/debug port. <CR><LF> characters will be automatically
 *          added to the end of the string
 * @param   format string & format
 */
void STB_SPDebugWrite(const char *format, ... )
{

}

/**
 * @brief   Writes debug string to the serial port without <CR><LF>
 * @param   format string & format
 */
void STB_SPDebugNoCnWrite(const char *format, ... )
{

}
#endif

/**
 * @brief   Report Assertion failure
 * @param   file name of source file
 * @param   line line number of source file
 * @param   eval_str evaluation string that failed
 */
void STB_SPDebugAssertFail(const char *file, int line, const char *eval_str)
{

}

/**
 * @brief   Returns the number of front end (Tuner) paths on the platform
 * @return  The number of tuner paths
 */
U8BIT STB_HWGetTunerPaths(void)
{
    U8BIT tuners = 0;
    
    for (uint32_t i = 0; i < 16; i++) {
        RTK_Error ret;
        unsigned char chipid;
        
	    ret == RTK_Tuner_GetDeviceChipid(i, &chipid);
        if (RTK_OK != ret)
            break;

        if (0xFF == chipid)
            break;

        tuners ++;
        printf("\n chipid chipid chipid ==== %d \n",chipid);
	}

    tuners = 4;  // FIXME: hardcode for MXL254C
    return tuners;
}

/**
 * @brief   Returns the number of recordings that can take place at the same time
 * @return  The number of recordings
 */
U8BIT STB_HWGetNumRecorders(void)
{
    return 1;
}

/**
 * @brief   Returns the number of audio decoding paths on the platform
 * @return  The number of audio decode paths
 */
U8BIT STB_HWGetAudioDecodePaths(void)
{
    return 1;
}

/**
 * @brief   Returns the number of video decoding paths on the platform
 * @return  The number of video decode paths
 */
U8BIT STB_HWGetVideoDecodePaths(void)
{
    return 1;
}

/**
 * @brief   Queries the number of demux paths available
 * @return  The number of demux paths
 */
U8BIT STB_HWGetDemuxPaths(void)
{
    return 8;
}

/**
 * @brief   Returns the serial number of the Set Top Box
 * @return  The serial number
 */
U8BIT STB_HWGetNumCISlots(void)
{
    return 4;
}

/**
 * @brief   Returns the number of CI slots on the platorm
 * @return  The number of CI slots
 */
U8BIT STB_HWGetNumSCSlots(void)
{
    return 1;
}

/**
 * @brief   Returns the number of smart card slots on the platorm
 * @return  The number of smart card slots
 */
U8BIT* STB_HWGetOUI(void)
{
    return NULL;
}

/**
 * @brief   Returns the platform hardware identifier code
 * @return  The platform id
 */
U16BIT STB_HWGetHwId(void)
{
    return 0;
}

/**
 * @brief   Returns the platform customer identifier code
 * @return  The platform id
 */
U16BIT STB_HWGetCustomerId(void)
{
    return 0;
}

/**
 * @brief   Returns the serial number of the Set Top Box
 * @return  The serial number
 */
U32BIT STB_HWGetBoxSerialNumber(void)
{
    return 0;
}

/**
 * @brief   Gives the name (optionally including path) of the SQL database file
 * @param   pathname - array into which the full path will be written
 * @param   max_pathname_len - size of the pathname array
 * @return  TRUE if the pathname is returned successfully.
 */
BOOLEAN STB_GetSqlFileName(U8BIT *pathname, U16BIT max_pathname_len)
{
    return FALSE;
}

// VBI interface
void STB_HWInitialiseVBI(void)
{

}

void STB_HWVBIInsert(U8BIT *pes_data_field, U32BIT num_bytes)
{

}

