#include "stbhwini.h"
#include "stbhwav.h"
#include "stbhwc.h"
#include "stbhwdmx.h"
#include "stbhwmem.h"
#include "stbhwnet.h"
#include "stbhwosd.h"
#include "stbhwtun.h"
#include "dbgfuncs.h"

#include "rtk_hal.h"
#include "stbhwsdk.h"

/**
 * @brief   Initialise the platform layer by calling the platform layer initialisation functions
 *          that are appropriate for this platform.
 * @param   hw_subt The subtitling mode mask, indicates which types of subtitles are required
 */
void STB_HWInitialise(E_HW_SUBT_CONTROL_MASK hw_subt)
{
   S32BIT ret;
   U8BIT tuner_num;
   U8BIT demux_num;
   U8BIT audio_num;
   U8BIT video_num;

   FUNCTION_START(STB_HWInitialise);

   STB_SdkInitialise(4);  // [ main, pip, normal record, time-shift record ]

   ret = 0; /* SDK init */
   if (0 != ret)
   {
      /* on failure */
   }
   else
   {
      STB_MEMInitialiseRAM();

#ifdef DIRECTFB
      DirectFBInit(NULL, NULL);
      DirectFBCreate(&pgfx_dfb);
      pgfx_dfb->GetScreen(pgfx_dfb, 0, &pdfb_screen);
      pgfx_dfb->SetCooperativeLevel(pgfx_dfb, DFSCL_NORMAL);

      STB_FPInitialise();
#endif

      STB_OSDInitialise(0);
      STB_DSKInitialise();
      STB_NWInitialise();
      STB_MEMInitialiseNVM();

      tuner_num = STB_HWGetTunerPaths();
      STB_TuneInitialise(tuner_num);

      demux_num = STB_HWGetDemuxPaths();
      STB_DMXInitialise(demux_num, FALSE);

      audio_num = STB_HWGetAudioDecodePaths();
      video_num = STB_HWGetVideoDecodePaths();
      STB_AVInitialise(audio_num, video_num);
   }

   FUNCTION_FINISH(STB_HWInitialise);
}

/**
 * @brief   Used to transition the system between the various standby states.
 *          It's assumed that the system can move to any state from any of the other states.
 * @param   state state the system is requesting to move to
 * @return  TRUE if the system has or will move to the requested state, FALSE otherwise
 */
BOOLEAN STB_HWSetStandbyState(E_HW_STANDBY_STATE state)
{
    return FALSE;
}

/**
 * @brief   Returns the current standby state of the system.
 *          STANDBY_LOWPOWER should never be returned by this function because in this state
 *          DVBCore is assumed not to be active
 * @return  current standby state
 */
E_HW_STANDBY_STATE STB_HWGetStandbyState(void)
{
    return HW_STANDBY_ACTIVE;
}

/**
 * @brief   Used to set the wake up time for when the system is going to be put into the low power
 *          standby state. Not all the supplied parameters are expected to be used, just those
 *          that are needed by the system to ensure the system wakes up at the required time.
 * @param   mjd wake up date in Modified Julian Date format
 * @param   year the year in full (e.g. 2016) the system is to wake up
 * @param   month month number (January=1, December=12) the system is to wake up
 * @param   day day number (1 to 28, 29, 30 or 31) the system is to wake up
 * @param   hours time in hours (0 to 23) the system is to wake up
 * @param   minutes time in minutes (0 to 59) the system is to wake up
 * @param   time_in_mins the time in minutes from the current date/time to the wake up time
 */
void STB_HWSetWakeUpTime(U16BIT mjd, U16BIT year, U8BIT month, U8BIT day, U8BIT hours,
   U8BIT minutes, U32BIT time_in_mins)
{
    return;
}

/**
 * @brief   Returns what caused the system to be powered on. This is used to work out what to
 *          do after being powered on (e.g. if due to user interaction then the system needs to
 *          enter the HW_STANDBY_ON state, whereas if it's due to the wake up timer then the system
 *          needs to work out what it needs to be do next, which may be to start a recording for
 *          a PVR type system, in which case it will enter the HW_STANDBY_ACTIVE state).
 * @return  the cause of the power on
 */
E_HW_WAKEUP_TYPE STB_HWGetWakeUpType(void)
{
    return HW_WAKEUP_UNKNOWN;
}

/**
 * @brief   Perform any operations required before entering standby
 * @deprecated This function is no longer used by DVBCore; STB_HWSetStandbyState is used instead.
 */
void STB_HWEnterStandby(void)
{
    return;
}

/**
 * @brief   Perform any operations required when coming out of standby
 * @deprecated This function is no longer used by DVBCore; STB_HWSetStandbyState is used instead.
 */
void STB_HWLeaveStandby(void)
{
    return;
}

