#include "stbhwmediaplayer.h"

/**
 * @brief   Initialises the media player module for the specified source
 * @param   source_url source URL to be presented
 * @return  media player handle
 */
void* STB_MPInit(U8BIT *source_url)
{
    return NULL;
}

/**
 * @brief   Starts the presentation of content
 * @param   handle media player handle
 * @param   params parameters to control the display
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPStart(void *handle, S_STB_MP_START_PARAMS *params)
{
    return HW_OK;
}

/**
 * @brief   Pauses the presentation of content
 * @param   handle media player handle
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPPause(void *handle)
{
    return HW_OK;
}

/**
 * @brief   Resumes the presentation of content
 * @param   handle media player handle
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPResume(void *handle)
{
    return HW_OK;
}

/**
 * @brief   Changes position of video on screen
 * @param   handle media player handle
 * @param   rect rectangle structure representing the expected position of video
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPResize(void *handle, S_RECTANGLE *rect)
{
    return HW_OK;
}

/**
 * @brief   Stops the presentation of content
 * @param   handle media player handle
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPStop(void *handle)
{
    return HW_OK;
}

/**
 * @brief   Uninitialises the media player module and invalidate the handle
 * @param   handle media player handle
 */
void STB_MPExit(void *handle)
{
    return;
}

/**
 * @brief   Returns start, current and end times in milliseconds for the content currently being
 *          presented.
 * @param   handle media player handle
 * @param   begin pointer to the variable where the begin time is stored. The value returned for the
 *          begin time depend on the platform implementation and might not be always 0.
 * @param   current pointer to the variable where the current time is stored.
 * @param   end pointer to the variable where the end time is stored
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPGetTimes(void *handle, U32BIT *begin, U32BIT *current, U32BIT *end)
{
    return HW_OK;
}

/**
 * @brief   Registers a callback to receive notifications of media player change of state
 * @param   handle media player handle
 * @param   callback pointer to the callback function
 */
void STB_MPRegisterCallback(void *handle, STB_MP_CALLBACK callback)
{
    return;
}

/**
 * @brief   Seeks the currently presented content to the specified position
 * @param   handle media player handle
 * @param   position position in milliseconds
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPSeek(void *handle, U32BIT position)
{
    return HW_OK;
}

/**
 * @brief   Returns a list of components of the specified type available in the currently presented
 *          content.
 * @param   handle media player handle
 * @param   type type of component or STB_MP_COMPONENT_ALL to receive all of them
 * @param   num_ptr pointer to the number of components found
 * @param   list_ptr pointer to the list, must be freed using STB_MPReleaseComponentList
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPObtainComponentList(void *handle, E_STB_MP_COMPONENT_TYPE type,
   U32BIT *num_ptr, S_STB_MP_COMPONENT_DETAILS **list_ptr)
{
    return HW_OK;
}

/**
 * @brief   Releases the list of components returned by STB_MPObtainComponentList
 * @param   handle media player handle
 * @param   list_ptr list to be freed
 */
void STB_MPReleaseComponentList(void *handle, S_STB_MP_COMPONENT_DETAILS *list_ptr)
{
    return;
}

/**
 * @brief   Forces the specifed component to be presented, if another component of the same type is
 *          already presented, it will be removed.
 * @param   handle media player handle
 * @param   component pointer to the componente to be presented, this must be one of the elements of
 *          the component list retured by STB_MPObtainComponentList.
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPSelectComponent(void *handle, S_STB_MP_COMPONENT_DETAILS *component)
{
    return HW_OK;
}

/**
 * @brief   Forces the specified component to be stopped
 * @param   handle media player handle
 * @param   component pointer to the componente to be presented, this must be one of the elements of
 *          the component list retured by STB_MPObtainComponentList.
 * @return  HW_OK if successful, error code otherwise
 */
E_HW_STATUS STB_MPUnselectComponent(void *handle, S_STB_MP_COMPONENT_DETAILS *component)
{
    return HW_OK;
}

/**
 * @brief   Returns the actual value of the error when the media player status is STB_MP_STATE_ERROR
 * @return  Error code when the media player is in STB_MP_STATE_ERROR status, STB_MP_NO_ERROR
 *          otherwise
 */
E_STB_MP_ERROR STB_MPGetError(void *handle)
{
    return STB_MP_UNDEFINED;
}

