/*******************************************************************************
 * Copyright © 2017 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Benchmark for functions: measures time of each function execution.
 *          Simply include this file into the file you want to benchmark (after 
 *          dbgfuncs.h, if it is included), and it will print the duration of functions
 *          execution (in miliseconds) on every FUNCTION_FINISH macro.
 *          Additionally it is possible to print elapsed time since function start in
 *          any place of the function by using BENCH_CHECK(<function_name>) macro.
 * @file    benchfuncs.h
 * @date    January 2018
 */

#ifndef _BENCHFUNCS_H
#define _BENCHFUNCS_H


/*--- Includes ----------------------------------------------------------------*/

#include "techtype.h"

/*--- Preprocessor definitions ------------------------------------------------*/

#define BENCH_START(name) \
   U32BIT timestamp_##name = STB_OSGetClockMilliseconds();\
   printf("%s - start\n", #name)

#define BENCH_CHECK(name) \
   printf("%s - check[%d]: %d\n", #name, __LINE__, STB_OSGetClockDiff(timestamp_##name))

#define BENCH_FINISH(name) \
   printf("%s - finish: %d\n", #name, STB_OSGetClockDiff(timestamp_##name))

#ifdef FUNCTION_START
#undef FUNCTION_START
#endif 

#ifdef FUNCTION_FINISH
#undef FUNCTION_FINISH
#endif


#define FUNCTION_START(x) BENCH_START(x)
#define FUNCTION_FINISH(x) BENCH_FINISH(x)


/*--- Global types definitions ------------------------------------------------*/

/*--- Global variables --------------------------------------------------------*/

/*--- Global function declarations --------------------------------------------*/


#endif /*  _BENCHFUNCS_H */

/****************************************************************************
** End of file
*****************************************************************************/


