/*******************************************************************************
 * Copyright © 2017 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   DTVKit platform global declarations for internal use
 * @file    internal_generic.h
 * @date
 */

#ifndef _INTERNAL_GENERIC_H
#define _INTERNAL_GENERIC_H



/*--- Includes ----------------------------------------------------------------*/

#include <stdio.h>

/*--- Preprocessor definitions ------------------------------------------------*/

#define FMT_GREEN   "\e[32m"
#define FMT_YELLOW  "\e[33m"
#define FMT_RED     "\e[31m"
#define FMT_BOLD    "\e[1m"
#define FMT_END     "\e[0m"

//#define STB_LOG_TO_ANDROID
#ifdef STB_LOG_TO_ANDROID
#warning "Log to android logcat DtvkitPlatform-YYY"
#include <android/log.h>
#define STB_DEBUG_LOG(module, format, args...) ((void)__android_log_print(ANDROID_LOG_DEBUG, "DtvkitPlatform-" module, format, ##args))
#define STB_WARNING_LOG(module, format, args...) ((void)__android_log_print(ANDROID_LOG_WARN, "DtvkitPlatform-" module, format, ##args))
#define STB_ERROR_LOG(module, format, args...) ((void)__android_log_print(ANDROID_LOG_ERROR, "DtvkitPlatform-" module, format, ##args))
#else
#define STB_DEBUG_LOG(module, format, args...) do { \
   fprintf(stdout, FMT_BOLD FMT_GREEN "%s DBG" FMT_END " [%s:%d]: ", module, __FILE__, __LINE__); \
   fprintf(stdout, format, ##args); \
   fprintf(stdout, "\n"); \
} while (0)

#define STB_WARNING_LOG(module, format, args...) do { \
   fprintf(stderr, FMT_BOLD FMT_YELLOW "%s WRN" FMT_END " [%s:%d]: ", module, __FILE__, __LINE__); \
   fprintf(stderr, format, ##args); \
   fprintf(stderr, "\n"); \
} while (0)

#define STB_ERROR_LOG(module, format, args...) do { \
   fprintf(stderr, FMT_BOLD FMT_RED "%s ERR" FMT_END " [%s:%d]: ", module, __FILE__, __LINE__); \
   fprintf(stderr, format, ##args); \
   fprintf(stderr, "\n"); \
} while (0)
#endif

/*--- Global variables --------------------------------------------------------*/

/*--- Global types definitions ------------------------------------------------*/

/*--- Global function declarations --------------------------------------------*/


/*!**************************************************************************
 * @fn      DSK_Terminate
 * @brief
 ****************************************************************************/
void DSK_Terminate(void);



/*!**************************************************************************
 * @fn      NW_Terminate
 * @brief
 ****************************************************************************/
void NW_Terminate(void);



/*!**************************************************************************
 * @fn      CI_GetSecureCiData
 * @brief   Allocate buffer and read secure CI data
 * @param   buffer - (out) address of the pointer to allocated buffer.
 * @return  buffer size in bytes, 0 in case of failure.
 * @warning buffer should later be manually released by calling CI_ReleaseSecureCiData
 ****************************************************************************/
int CI_GetSecureCiData(void **buffer);



/*!**************************************************************************
 * @fn      CI_ReleaseSecureCiData
 * @brief   Release secure CI data buffer
 * @param   buffer - pointer to CI data buffer which should be released.
 ****************************************************************************/
void CI_ReleaseSecureCiData(void *buffer);

#endif /* _INTERNAL_GENERIC_H */

/****************************************************************************
** End of file
*****************************************************************************/
