/*******************************************************************************
 * Copyright © 2017 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Platform Specific Hardware Definitions
 * @file    stbhwdef.h
 * @date    February 2001
 */

#ifndef _STBHWDEF_H
#define _STBHWDEF_H


/*--- Includes ----------------------------------------------------------------*/

/*--- Preprocessor definitions ------------------------------------------------*/

/* TODO [code style]: check if all below definitions really need to be in this header,
 * which is exposed to other packages */

#define KBYTES                   1024

#define SD_WIDTH                 720
#define SD_HEIGHT                576
#define HD_WIDTH                 1280
#define HD_HEIGHT                720
#define FULL_HD_WIDTH            1920
#define FULL_HD_HEIGHT           1080

#define DEFAULT_VIDEO_FORMAT     VIDEO_FORMAT_720HD
#define SCREEN_WIDTH             FULL_HD_WIDTH
#define SCREEN_HEIGHT            FULL_HD_HEIGHT

#define SCREEN_COLOUR_DEPTH      32

#define HD_SCALE_W(x)            (((x * SCREEN_WIDTH) + (FULL_HD_WIDTH / 2)) / FULL_HD_WIDTH)
#define HD_SCALE_H(x)            (((x * SCREEN_HEIGHT) + (FULL_HD_HEIGHT / 2)) / FULL_HD_HEIGHT)

/* Manufacturer string required by MHEG */
#define MANUFACTURER             "DTVKit"
#define SUBTITLES_AND_GRAPHICS   TRUE

/* Task config */
#define MHEG_TASK_PRIORITY       6

/* Not used by the platform, but used by the CI glue to define the max number of slots */
#define NUM_CI_SLOTS             0
#define NUM_SC_SLOTS             1

#define NUM_DEMUX_PATHS          5
#define NUM_DECODE_PATHS         1
#define NUM_RECORDERS            1

#define NUM_TUNER_PATHS          1

#define NUM_TUNER_RETRIES        1

/* NV specific configuration */
#define NV_DEVICE_SIZE           (256 * KBYTES)    // Amount of NV flash used by the application

#define MAX_STC_SPEED            2.0

#define DSC_INDEX_LIVE_PLAY      1
#define DSC_INDEX_PVR_RECORD     2
#define DSC_INDEX_PVR_PLAYBACK   4
#define DSC_INDEX_PVR_ENCRYPT    5

#define KL_INDEX_PVR_PLAYBACK    12
#define KL_INDEX_PVR_ENCRYPT     10

#ifdef INC_FRONTPANEL_DISPLAY
#define PANEL_SCROLL_DELAY       90
#endif

#ifndef DTVKIT_PLATFORM
#define DTVKIT_PLATFORM                 "dtvkit_platform"
#endif

#ifndef DTVKIT_ENCRYPT_PLATFORM_PLAY
#define DTVKIT_ENCRYPT_PLATFORM_PLAY    "dtvkit_platrofm_ca_play"
#endif

#ifndef DTVKIT_ENCRYPT_PLATFORM_RECORD
#define DTVKIT_ENCRYPT_PLATFORM_RECORD  "dtvkit_platrofm_ca_record"
#endif


/*--- Global types definitions ------------------------------------------------*/


/*--- Global function declarations --------------------------------------------*/

/*!**************************************************************************
 * @fn      STB_OSDRegisterDrawHandler
 * @brief   Register app fn that can be called to redraw OSD
 * @param   subscriber
 * @param   func - the callback function
 * @note    Used in dtvkitqt
 ****************************************************************************/
void STB_OSDRegisterDrawHandler(void *subscriber, void (*func)(void *subscriber, char *image,
                                                               int pitch, int width, int height));



/*!**************************************************************************
 * @fn      STB_OSDDrawCallback
 * @brief   Can be called by anyone to force redraw of the OSD by the UI
 * @param   image
 * @param   pitch
 * @param   width
 * @param   height
 ****************************************************************************/
void STB_OSDDrawCallback(char *image, int pitch, int width, int height);



/*!**************************************************************************
 * @fn      STB_TuneGetSnr
 * @brief   Returns the Signal Noise Ratio
 * @param   path - the tuner path to query
 * @return  the unit of snr is 0.1dB
 ****************************************************************************/
U32BIT STB_TuneGetSnr(U8BIT path);



/*!**************************************************************************
 * @fn      STB_TuneGetBer
 * @brief   Returns the Bit Error Rate
 * @param   path - the tuner path to query
 * @return  bit_error_ratio (BER) in 1.0E-7(i.e. 10^-7) unit
 ****************************************************************************/
U32BIT STB_TuneGetBer(U8BIT path);



/*!**************************************************************************
 * @fn      STB_TuneGetOverloadState
 * @brief   Get Overload State
 * @param   path - tuner path
 * @param   overload_flag - 1:overload 0:normal 0xff:unsupported
 ****************************************************************************/
U8BIT STB_TuneGetOverloadState(U8BIT path);



/*!**************************************************************************
 * @fn      STB_TuneActiveAerialPower
 * @brief   Enables/disables aerial power for DVB-T
 * @param   path - tuner path
 * @param   enabled - TRUE to enable
 ****************************************************************************/
void STB_TuneActiveAerialPower(U8BIT path, BOOLEAN enabled);
#endif /*  _STBHWDEF_H */

/****************************************************************************
** End of file
*****************************************************************************/
