/*******************************************************************************
 * Copyright © 2017 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Set Top Box - Linux DirectFB variables and functions.
 *          Declarations and Constants for DirectFB users (AV, OSD, FP)
 * @file    stbhwdfb.h
 * @date    September 2007
 * @author  Dave Carter
 */

#ifndef _STBHWDFB_H
#define _STBHWDFB_H
#ifdef DIRECTFB

/*--- Includes ----------------------------------------------------------------*/

/* Needed for IDirectFB type */
#include <directfb.h>


/*--- Preprocessor definitions ------------------------------------------------*/

#define GRAPHICS_1_LMASK  0x01
#define GRAPHICS_2_LMASK  0x02
#define DISPLAY_1_LMASK   0x04
#define DISPLAY_2_LMASK   0x08

#ifndef NDEBUG
#define DFB_DEBUG
#endif

#ifdef DFB_DEBUG
#define DFBCHECK(x...)                                       \
{                                                            \
   DFBResult err = x;                                        \
   if (err != DFB_OK)                                        \
   {                                                         \
      fprintf(stderr, "%s <%d>:\n\t", __FILE__, __LINE__);   \
      DirectFBErrorFatal(#x, err);                           \
   }                                                         \
}
#else
#define DFBCHECK(x...) x;
#endif


/*--- Global types definitions ------------------------------------------------*/

typedef enum dfb_layer_ids
{
   DLID_PRIMARY_GRAPHICS = 0,
   DLID_PRIMARY_VIDEO,
   DLID_SECOND_VIDEO,
   /* end with the max number of layers */
   MAX_NUM_LAYERS
} E_DFB_LAYER_IDS;

typedef enum mixers
{
   MIXER_ANALOG,
   MIXER_HDMI
} E_MIXERS;

typedef enum encoders
{
   ENCODER_HDMI,
   ENCODER_ANALOG
} E_ENCODERS;


/*--- Global variables --------------------------------------------------------*/

/* TODO [code style]: eliminate usage of global variables */
extern IDirectFB *pgfx_dfb;
extern IDirectFBScreen *pdfb_screen;
extern BOOLEAN ui_pixelformat_lut8;


/*--- Global function declarations --------------------------------------------*/

/*!**************************************************************************
 * @fn      OSD_Terminate
 * @brief
 ****************************************************************************/
extern void OSD_Terminate(void);


#endif
#endif /* _STBHWDFB_H */

/****************************************************************************
** End of file
*****************************************************************************/
