/*******************************************************************************
 * Copyright  2014 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright  2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Header file - Function prototypes for Demux control
 * @file    stbhwsmc.h
 * @date    06/02/2001
 */

// pre-processor mechanism so multiple inclusions don't cause compilation error

#ifndef _STBHWSMC_H
#define _STBHWSMC_H


/* return of smart card */
typedef enum
{
	STB_SMC_OK = 0,
	STB_SMC_FAILED,
}STB_SMC_RET;

/* status of smart card */
typedef enum
{
	STB_SMC_IN = 0,
	STB_SMC_OUT,
	STB_SMC_UNKNOWN,
}STB_SMC_Status;


 /**
  *
  * STB_SMC_Init
  *
  * Smartcard initialization
  *
  * @Param			user callback to register
  *
  * @Return 		STB_SMC_OK if success else STB_SMC_FAILED
  *
  */
 STB_SMC_RET STB_SMC_Init(void *callback);


 /**
  *
  *  STB_SMC_Close
  *
  * close smart card
  *
  * @Param			none
  *
  * @Return 		STB_SMC_OK or STB_SMC_FAILED
  *
  */
 STB_SMC_Status STB_SMC_Detect(void);


 /**
  *
  *  STB_SMC_Close
  *
  * close smart card
  *
  * @Param			none
  *
  * @Return 		STB_SMC_OK or STB_SMC_FAILED
  *
  */
 STB_SMC_RET STB_SMC_Close(void);


 /**
  *
  *  STB_SMC_Reset
  *
  * reset smart card
  *
  * @Param			none
  *
  * @Return 		STB_SMC_OK or STB_SMC_FAILED
  *
  */
 STB_SMC_RET STB_SMC_Reset(void);


 /**
  *
  *  STB_SMC_GetParam
  *
  * get params of smart card
  *
  * @Param			pvParams  pointer to put the params
  * @Param			pwLen  pointer to the length of params
  *
  * @Return 		STB_SMC_OK 
  *
  */
 STB_SMC_RET STB_SMC_GetParam(unsigned char *pvParams, unsigned short *pwLen);



 /**
  *
  *  STB_SMC_isExist
  *
  * get status of smart card
  *
  * @Param			none
  *
  * @Return 		STB_SMC_OK if smart card exists, else STB_SMC_FAILED
  *
  */
 STB_SMC_RET STB_SMC_isExist(void);

 
 /**
  *
  * STB_SMCTransfer
  *
  * Smartcard start trasnfer
  *
  * @Param	   send_data_ptr	  pointer to send command
  * @param	   send_data_len	  send command length
  * @param	   recv_data_ptr	   pointer to received data
  * @param	   recvd_data_len	  pointer to received data length
  *
  * @Return 		   E_SMC_OK if success else E_SMC_FAILED
  *
  */
 STB_SMC_RET STB_SMC_Transfer ( unsigned char *send_data_ptr,	 
									   unsigned int  send_data_len,  
									   unsigned char *recv_data_ptr,  
									   unsigned int *recvd_data_len 
									  ); 

#endif

