/*******************************************************************************
 * Copyright © 2017 The DTVKit Open Software Foundation Ltd (www.dtvkit.org)
 * Copyright © 2004 Ocean Blue Software Ltd
 *
 * This file is part of a DTVKit Software Component
 * You are permitted to copy, modify or distribute this file subject to the terms
 * of the DTVKit 1.0 Licence which can be found in licence.txt or at www.dtvkit.org
 *
 * THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * If you or your organisation is not a member of DTVKit then you have access
 * to this source code outside of the terms of the licence agreement
 * and you are expected to delete this and any associated files immediately.
 * Further information on DTVKit, membership and terms can be found at www.dtvkit.org
 *******************************************************************************/
/**
 * @brief   Set Top Box - STB810 Hardware Layer, Serial Port (Debug) functions
 * @file    stbhwsp.c
 * @date    October 2007
 * @author  Dave Carter
 */


/*--- Includes ----------------------------------------------------------------*/

/* System header files */
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

/* Third party header files */

/* STB header files*/
#include "techtype.h"
#include "dbgfuncs.h"
#include "stbhwc.h"
#include "android/log.h"

#define REDIRECT_LOGCAT

/*--- Preprocessor definitions ------------------------------------------------*/

#define BAUD_RATE_LUT_SIZE 8


/*--- Local types definitions -------------------------------------------------*/

/*--- Local (static) variable declarations ------------------------------------*/

static char debug_msg_buff[4096];


/*--- Local function prototypes -----------------------------------------------*/

/*--- Global function definitions ---------------------------------------------*/


/*!**************************************************************************
 * @fn      STB_SPDebugWrite
 * @brief   Write debug string to serial/debug port
 * @param   format - string & format
 ****************************************************************************/
void STB_SPDebugWrite(const char *format, ...)
{
   U16BIT len;
   va_list vparams;

   /* Warning!!! Don't put FUNCTION_START and FUNCTION_FINISH macro 
    * to this function, because it will cause infinite recursion */

   ASSERT(format != NULL);

   va_start(vparams, format);
   vsprintf(debug_msg_buff, format, vparams);
   va_end(vparams);
   len = strlen(debug_msg_buff);
   sprintf(&debug_msg_buff[len], "\r\n");

#ifdef REDIRECT_LOGCAT
   __android_log_print(ANDROID_LOG_INFO,"dtvkit","%s", debug_msg_buff);
#else
   printf("%s", debug_msg_buff);
   fflush(stdout);
#endif
}



/*!**************************************************************************
 * @fn      STB_SPDebugNoCnWrite
 * @brief   Writes debug string to the serial port without <CR><LF>
 * @param   format - string & format
 ****************************************************************************/
void STB_SPDebugNoCnWrite(const char *format, ...)
{
   // U16BIT len;
   va_list vparams;

   ASSERT(format != NULL);

   va_start(vparams, format);
   vsprintf(debug_msg_buff, format, vparams);
   va_end(vparams);
   // len = strlen(debug_msg_buff);

#ifdef REDIRECT_LOGCAT
   __android_log_print(ANDROID_LOG_INFO,"DTVKit","%s", debug_msg_buff);
#else
   printf("%s", debug_msg_buff);
   fflush(stdout);
#endif
}



#if 0
/* Stub functions not used on this platform to maintain API */

/*!**************************************************************************
 * @fn      STB_SPInitialise
 * @brief
 ****************************************************************************/
void STB_SPInitialise(void)
{
   FUNCTION_START(STB_SPInitialise);
   FUNCTION_FINISH(STB_SPInitialise);
}

/*!**************************************************************************
 * @fn      STB_SPOpen
 * @brief
 * @param   baud
 * @param   data
 * @param   stop
 * @param   handshaking
 * @return
 ****************************************************************************/
BOOLEAN STB_SPOpen(U32BIT baud, E_STB_SP_DATA_MODE data,
                   E_STB_SP_STOP_MODE stop, E_STB_SP_HANDSHAKING handshaking)
{
   FUNCTION_START(STB_SPOpen);
   USE_UNWANTED_PARAM(baud);
   USE_UNWANTED_PARAM(data);
   USE_UNWANTED_PARAM(stop);
   USE_UNWANTED_PARAM(handshaking);
   FUNCTION_FINISH(STB_SPOpen);
   return TRUE;
}

/*!**************************************************************************
 * @fn      STB_SPClose
 * @brief
 ****************************************************************************/
void STB_SPClose(void)
{
   FUNCTION_START(STB_SPClose);
   FUNCTION_FINISH(STB_SPClose);
}

/*!**************************************************************************
 * @fn      STB_SPEnquireBaud
 * @brief
 * @param   baud
 * @return
 ****************************************************************************/
U32BIT STB_SPEnquireBaud (U32BIT baud)
{
   FUNCTION_START(STB_SPEnquireBaud);
   FUNCTION_FINISH(STB_SPEnquireBaud);
   return baud;
}

/*!**************************************************************************
 * @fn      STB_SPWrite
 * @brief
 * @param   data
 * @param   len
 * @param   timeout
 * @param   written
 ****************************************************************************/
void STB_SPWrite(U8BIT *data, U32BIT len, U32BIT timeout, U32BIT *written)
{
   FUNCTION_START(STB_SPWrite);
   USE_UNWANTED_PARAM(data);
   USE_UNWANTED_PARAM(len);
   USE_UNWANTED_PARAM(timeout);
   USE_UNWANTED_PARAM(written);
   FUNCTION_FINISH(STB_SPWrite);
}

/*!**************************************************************************
 * @fn      STB_SPRead
 * @brief
 * @param   data
 * @param   len
 * @param   timeout
 * @param   read
 ****************************************************************************/
void STB_SPRead(U8BIT *data, U32BIT len, U32BIT timeout, U32BIT *read)
{
   FUNCTION_START(STB_SPRead);
   USE_UNWANTED_PARAM(data);
   USE_UNWANTED_PARAM(len);
   USE_UNWANTED_PARAM(timeout);
   USE_UNWANTED_PARAM(read);
   FUNCTION_FINISH(STB_SPRead);
}

/*!**************************************************************************
 * @fn      STB_SPOpenAux
 * @brief
 * @param   baud
 * @param   data
 * @param   stop
 * @param   handshaking
 * @return
 ****************************************************************************/
BOOLEAN STB_SPOpenAux(U32BIT baud, E_STB_SP_DATA_MODE data,
                      E_STB_SP_STOP_MODE stop, E_STB_SP_HANDSHAKING handshaking)
{
   FUNCTION_START(STB_SPOpenAux);
   USE_UNWANTED_PARAM(baud);
   USE_UNWANTED_PARAM(data);
   USE_UNWANTED_PARAM(stop);
   USE_UNWANTED_PARAM(handshaking);
   FUNCTION_FINISH(STB_SPOpenAux);
   return FALSE;
}

/*!**************************************************************************
 * @fn      STB_SPCloseAux
 * @brief
 ****************************************************************************/
void STB_SPCloseAux(void)
{
   FUNCTION_START(STB_SPCloseAux);
   FUNCTION_FINISH(STB_SPCloseAux);
}

/*!**************************************************************************
 * @fn      STB_SPWriteAux
 * @brief
 * @param   data
 * @param   len
 * @param   timeout
 * @param   written
 ****************************************************************************/
void STB_SPWriteAux(U8BIT *data, U32BIT len, U32BIT timeout, U32BIT *written)
{
   FUNCTION_START(STB_SPWriteAux);
   USE_UNWANTED_PARAM(data);
   USE_UNWANTED_PARAM(len);
   USE_UNWANTED_PARAM(timeout);
   USE_UNWANTED_PARAM(written);
   FUNCTION_FINISH(STB_SPWriteAux);
}

/*!**************************************************************************
 * @fn      STB_SPReadAux
 * @brief
 * @param   data
 * @param   len
 * @param   timeout
 * @param   read
 ****************************************************************************/
void STB_SPReadAux(U8BIT *data, U32BIT len, U32BIT timeout, U32BIT *read)
{
   FUNCTION_START(STB_SPReadAux);
   USE_UNWANTED_PARAM(data);
   USE_UNWANTED_PARAM(len);
   USE_UNWANTED_PARAM(timeout);
   USE_UNWANTED_PARAM(read);
   FUNCTION_FINISH(STB_SPReadAux);
}
#endif



/*--- Local function definitions ----------------------------------------------*/


/****************************************************************************
** End of file
*****************************************************************************/
