#ifndef _STB_HW_SDK_H
#define _STB_HW_SDK_H

#ifdef __cplusplus

#include "techtype.h"
#include "rtk_hal_base.h"
#include "rtk_hal.h"
#include "realtek_player.h"

/**
 * @brief   Initialises the SDK
 * @param   paths number to initialise
 */
void STB_SdkInitialise(U8BIT paths);

RealtekPlayer * STB_SdkGetRealtekPlayer(U8BIT path);
void STB_SdkSetRealtekPlayer(U8BIT path, RealtekPlayer * player);

RTK_Player STB_SdkGetPlayer(U8BIT path);

RTK_Source * STB_SdkGetSource(U8BIT path);

RTK_PlayerConfig * STB_SdkGetPlayerConfig(U8BIT path);

#endif

#ifdef __cplusplus
extern "C" {
#endif

void STB_SDKSwitchLivePath(U8BIT fromPath, U8BIT toPath);

#ifdef __cplusplus
}
#endif

#endif /*  _STB_HW_SDK_H */


