#include "techtype.h"
#include "dbgfuncs.h"
#include "stbhwsdk.h"
#include "stbhwmem.h"

#include <sys/stat.h>
#include <map>

#define DTVKIT_DATA_PATH       "/data/vendor/dtvkit"

typedef struct {
	RTK_Bool eof_reached;
} PlayerStatus;

RealtekPlayer **gRealtekPlayer = NULL;

RTK_Player *gRTK_Player = NULL;
PlayerStatus *gPlayerStatus = NULL;
RTK_PlayerConfig * gRTK_PlayerConfig = NULL;

RTK_Source *gRTK_Source = NULL;
RTK_Source *gRTK_Source_Prev = NULL;  // for FCC
RTK_Source *gRTK_Source_Next = NULL;  // for FCC

RTK_VideoConfig *gRTK_VideoConfig;
RTK_AudioConfig *gRTK_AudioConfig;

U8BIT num_of_player = 0;

/**
 * @brief   Initialises the tuner component
 * @param   paths number of tuning paths to initialise
 */
void STB_SdkInitialise(U8BIT paths)
{
    const char * pathname = DTVKIT_DATA_PATH;
    struct stat statbuf;
   
    /* Check whether the directory already exists */
    if (stat(pathname, &statbuf) != 0) {
       if (mkdir((char*) pathname, (S_IRWXU | S_IRWXG | S_IRWXO)) != 0)
          goto error;
    }

#if 1 // FIXME: a blurred screen when zapping, the last frame is missing
    RTK_initialize();
    RT_SetSMP(RTK_TRUE);
#endif
    
    // RealtekPlayer
    gRealtekPlayer = (RealtekPlayer **) STB_MEMGetSysRAM(sizeof(RealtekPlayer *) * paths);
    if (NULL == gRealtekPlayer) {
        printf("Failed to allocate memory for RealtekPlayer");
        goto error;
    }
    memset(gRealtekPlayer, 0, sizeof(RealtekPlayer *) * paths);

    // RTK_Player
    gRTK_Player = (RTK_Player *) STB_MEMGetSysRAM(sizeof(RTK_Player) * paths);
    if (NULL == gRTK_Player) {
        printf("Failed to allocate memory for RTK_Player");
        goto error;
    }
    memset(gRTK_Player, 0, sizeof(RTK_Player) * paths);
    // PlayerStatus
    gPlayerStatus = (PlayerStatus *) STB_MEMGetSysRAM(sizeof(PlayerStatus) * paths);
    if (NULL == gPlayerStatus) {
        printf("Failed to allocate memory for PlayerStatus");
        goto error;
    }
    memset(gPlayerStatus, 0, sizeof(PlayerStatus) * paths);
    // RTK_PlayerConfig
    gRTK_PlayerConfig = (RTK_PlayerConfig *) STB_MEMGetSysRAM(sizeof(RTK_PlayerConfig) * paths);
    if (NULL == gRTK_PlayerConfig) {
        printf("Failed to allocate memory for RTK_PlayerConfig");
        goto error;
    }
    memset(gRTK_PlayerConfig, 0, sizeof(RTK_PlayerConfig) * paths);
    // RTK_Source
    gRTK_Source = (RTK_Source *) STB_MEMGetSysRAM(sizeof(RTK_Source) * (paths + 2));
    if (NULL == gRTK_Source) {
        printf("Failed to allocate memory for RTK_Source");
        goto error;
    }
    memset(gRTK_Source, 0, sizeof(RTK_Source) * (paths + 2));
    gRTK_Source_Prev = &gRTK_Source[paths];
    gRTK_Source_Next = &gRTK_Source[paths + 1];

    // RTK_VideoConfig
    gRTK_VideoConfig = (RTK_VideoConfig *) STB_MEMGetSysRAM(sizeof(RTK_VideoConfig) * paths);
    if (NULL == gRTK_VideoConfig) {
        printf("Failed to allocate memory for RTK_VideoConfig");
        goto error;
    }
    memset(gRTK_VideoConfig, 0, sizeof(RTK_VideoConfig) * paths);

    // RTK_AudioConfig
    gRTK_AudioConfig = (RTK_AudioConfig *) STB_MEMGetSysRAM(sizeof(RTK_AudioConfig) * paths);
    if (NULL == gRTK_AudioConfig) {
        printf("Failed to allocate memory for RTK_AudioConfig");
        goto error;
    }
    memset(gRTK_AudioConfig, 0, sizeof(RTK_AudioConfig) * paths);

    num_of_player = paths;
    return;

error:
    if (NULL != gRTK_Player) {
        STB_MEMFreeSysRAM(gRTK_Player);
        gRTK_Player = NULL;
    }
    if (NULL != gPlayerStatus) {
        STB_MEMFreeSysRAM(gPlayerStatus);
        gPlayerStatus = NULL;
    }
    if (NULL != gRTK_PlayerConfig) {
        STB_MEMFreeSysRAM(gRTK_PlayerConfig);
        gRTK_PlayerConfig = NULL;
    }
    if (NULL != gRTK_Source) {
        STB_MEMFreeSysRAM(gRTK_Source);
        gRTK_Source = NULL;
    }
    return;
}

RealtekPlayer * STB_SdkGetRealtekPlayer(U8BIT path)
{
    RealtekPlayer * player = NULL;
    
    if (num_of_player && (num_of_player > path)) {
        player = gRealtekPlayer[path];
    }

    return player;
}

void STB_SdkSetRealtekPlayer(U8BIT path, RealtekPlayer * player)
{
    if (num_of_player && (num_of_player > path)) {
        gRealtekPlayer[path] = player;
    }
}

RTK_Player STB_SdkGetPlayer(U8BIT path)
{
   RTK_Player hRTK_Player = NULL;
    
    if (num_of_player && (num_of_player > path)) {
      if (NULL != gRealtekPlayer[path])
         hRTK_Player = gRealtekPlayer[path]->getDemux();
    }

    return hRTK_Player;
}

RTK_PlayerConfig * STB_SdkGetPlayerConfig(U8BIT path)
{
    RTK_PlayerConfig * config = NULL;
    
    if (num_of_player && (num_of_player > path)) {
        config = &gRTK_PlayerConfig[path];
    }

    return config;
}

RTK_Source * STB_SdkGetSource(U8BIT path)
{
    RTK_Source * source = NULL;
    
    if (num_of_player && (num_of_player > path)) {
        source = &gRTK_Source[path];
    }

    return source;
}

RTK_Source * STB_SdkGetFccSource(BOOLEAN next)
{
    RTK_Source * source = NULL;
    
    if (TRUE == next)
        source = gRTK_Source_Next;
    else
        source = gRTK_Source_Prev;

    return source;
}


RTK_VideoConfig * STB_SdkGetVideoConfig(U8BIT path)
{
    RTK_VideoConfig * videoConfig = NULL;
    
    if (num_of_player && (num_of_player > path)) {
        videoConfig = &gRTK_VideoConfig[path];
    }

    return videoConfig;
}

RTK_AudioConfig * STB_SdkGetAudioConfig(U8BIT path)
{
    RTK_AudioConfig * audioConfig = NULL;
    
    if (num_of_player && (num_of_player > path)) {
        audioConfig = &gRTK_AudioConfig[path];
    }

    return audioConfig;
}

void STB_SDKSwitchLivePath(U8BIT fromPath, U8BIT toPath)
{
   RealtekPlayer::switchSource(gRealtekPlayer[fromPath], gRealtekPlayer[toPath]);

   RealtekPlayer * pRealtekPlayer = gRealtekPlayer[fromPath];   
   gRealtekPlayer[fromPath] = gRealtekPlayer[toPath];
   gRealtekPlayer[toPath] = pRealtekPlayer;
}
