#!/bin/sh

# this function is called when Ctrl-C is sent
trap_ctrlc () {
    echo "Ctrl-C caught...performing clean up"
    adb disconnect
    exit 2
}

trap "trap_ctrlc" 2
 
adb disconnect
adb connect $1
adb wait-for-device root
adb logcat -G 64m

adb logcat
# TAGs
# input source - DTV-SearchChannel,DTV-SearchChannelSetup,DTV-SignalDetection,DTV-Update
#                DtvkitTvInput,DtvkitTvInputSession,DtvkitTvInputRecordingSession
#                EpgSyncJobService
#                DtvkitDvbcSetup,DtvkitGlueClient,DtvkitReceiver
#                DtvkitTvPlayer,TvMediaPlayer,TransportManager,DashRendererBuilder
# interfaces -   DtvkitPlayerInterface,vendor.dtvkit.hardware.dtvkit@1.0-service
# DVBCore -      dtvkit
#adb logcat -s DtvkitTvInput,DtvkitPlayerInterface,DVBCore,dtvkit,TvApplication

adb disconnect

