LOCAL_PATH:= $(call my-dir)

ENABLE_CDCA_CLIENT = YES
ENABLE_CDCA_CLIENT_EX = YES

ENABLE_SC = YES
ENABLE_VENDOR_LIB = YES

HAVE_LIB_DIR := $(shell test -d  $(LOCAL_PATH)/lib_release && echo YES)
$(warning "lib_release is exist: $(HAVE_LIB_DIR)")

ifeq ($(HAVE_LIB_DIR), YES)
include $(LOCAL_PATH)/gen_libs.mk
endif

###############################################################################
#
#libcdca_client.so
#only implement parts of CDSTBCA_xxx apis 
#The lib is only for hwacom
###############################################################################

ifeq ($(ENABLE_CDCA_CLIENT), YES)

include $(CLEAR_VARS)
LOCAL_MODULE := libcdca_client
LOCAL_MODULE_TAGS := optional
LOCAL_SRC_FILES:= \
		CDCAClient/Src/cdca_client.cpp \

LOCAL_C_INCLUDES:= \
		$(LOCAL_PATH)/Include \
		$(LOCAL_PATH)/CDCAClient/Inc \
		$(LOCAL_PATH)/CDCAPorting/Inc \
		$(LOCAL_PATH)/Util/Inc/ \
		system/core/include/ion \
		vendor/realtek/RTKHAL/Include\
		vendor/realtek/RTKPLAYER/RTKHAL_Base/inc \
		vendor/realtek/RTKPLAYER/RTK_HAL_PLAYER_MOD/inc \
		system/core/include/cutils \
		vendor/realtek/RTKHAL/Extra/Rtk_Socket/inc/ \
		vendor/realtek/RTKHAL/RTK_Utility/rtk_client_util/inc/ \
		device/realtek/proprietary/libs/RtkRpcClientServer \


LOCAL_SHARED_LIBRARIES := \
		librtksdk \
		libion \
		libRtkRpcClientServer \
		liblog \
		librtk_halPlayer \

LOCAL_STATIC_LIBRARIES := \
		libcutils \

LOCAL_PROPRIETARY_MODULE := true

#Get build info
LIBVERSION:=\"$(shell cd $(LOCAL_PATH);git log -1 --format=%h_%cd --date=format:'%Y%m%d_%H:%M:%S')\\n\"
LOCAL_CFLAGS += -DEXTERN_FUNC_NAME=$(LOCAL_MODULE)_getGitSha
LOCAL_CFLAGS += -DGIT_VERSION=\"$(LOCAL_MODULE)_version_\"$(LIBVERSION)
$(warning "the libcdca_client_version_ is$(LIBVERSION)")

LOCAL_CFLAGS += $(DEFINES)
LOCAL_CFLAGS += -fPIC
include $(BUILD_SHARED_LIBRARY)
endif

###############################################################
##############################################################
#lib libcdca_casIntf.so
#All of Apis that cdca need will be implemented 
###############################################################
ifeq ($(ENABLE_CDCA_CLIENT_EX), YES)
include $(CLEAR_VARS)

LOCAL_MODULE:= libcdca_casIntf
LOCAL_MODULE_TAGS := optional
LOCAL_SRC_FILES:= \
		CDCAPorting/Src/cdca_dmx.cpp \
		CDCAPorting/Src/cdca_interface.cpp \
		CDCAPorting/Src/cdca_os.cpp \
		CDCAPorting/Src/cdca_sys.cpp \
		CDCAPorting/Src/cdca_sc.cpp  \
        CDCAPorting/Src/cdca_nvm.cpp \

		ifeq ($(HAVE_LIB_DIR), YES)
        LOCAL_SRC_FILES += CDCAClient/Src/Rtk_CDCa.cpp 
		endif


LOCAL_C_INCLUDES:= \
		$(LOCAL_PATH)/Include \
		$(LOCAL_PATH)/CDCAClient/Inc \
		$(LOCAL_PATH)/CDCAPorting/Inc \
		$(LOCAL_PATH)/Util/Inc/optee_client \
		$(LOCAL_PATH)/Util/Inc/ \
		vendor/realtek/RTKHAL/Include \
		vendor/realtek/RTKHAL/Extra/Rtk_Socket/inc/ \
		vendor/realtek/RTKHAL/RTK_Utility/rtk_client_util/inc/ \
		vendor/realtek/RTKPLAYER/RTKHAL_Base/inc/ \
		vendor/realtek/RTKPLAYER/Rtk_CaIntf/include/ \
		device/realtek/proprietary/libs/RtkRpcClientServer \

    LOCAL_SHARED_LIBRARIES:= \
    liblog \
    librtksdk \
    librtk_halPlayer \
    libutils  \
    libcrypto \
    libteec
        
    LOCAL_PROPRIETARY_MODULE:= true

ifeq ($(ENABLE_VENDOR_LIB), YES)
    LOCAL_C_INCLUDES += $(LOCAL_PATH)/Include/VENDOR_SC
    LOCAL_SRC_FILES += CDCAClient/Src/Rtk_CDCa.cpp \
                       CDCAPorting/Src/cdstbca.cpp  
    LOCAL_CFLAGS += -DENABLE_SC
    LOCAL_CFLAGS += -DENABLE_VENDOR_LIB
    LOCAL_CFLAGS += -DENABLE_CA_LIB
    LOCAL_STATIC_LIBRARIES+= libcdcas
else
ifeq ($(ENABLE_SC), YES)
    LOCAL_C_INCLUDES += $(LOCAL_PATH)/Include/SC
    ifeq ($(HAVE_LIB_DIR), YES)
        LOCAL_STATIC_LIBRARIES+= libcdcas
        LOCAL_CFLAGS += -DENABLE_CA_LIB
    endif
    LOCAL_CFLAGS += -DENABLE_SC
else
    LOCAL_C_INCLUDES += $(LOCAL_PATH)/Include/NSC
    ifeq ($(HAVE_LIB_DIR), YES)
        LOCAL_STATIC_LIBRARIES+= libcdcas-cardless
        LOCAL_CFLAGS += -DENABLE_CA_LIB
    endif
endif
endif  # ifeq ($(ENABLE_VENDOR_LIB), YES)


#Get build info
LIBVERSION:=\"$(shell cd $(LOCAL_PATH);git log -1 --format=%h_%cd --date=format:'%Y%m%d_%H:%M:%S_enable_smartcard_'$(ENABLE_SC))\\n\"
LOCAL_CFLAGS += -DEXTERN_FUNC_NAME=$(LOCAL_MODULE)_getGitSha
LOCAL_CFLAGS += -DGIT_VERSION=\"$(LOCAL_MODULE)_version_\"$(LIBVERSION)
$(warning "the libcdca_casIntf_version_ is$(LIBVERSION)enable_smartcard_$(ENABLE_SC)")

LOCAL_CFLAGS += -fPIC
include $(BUILD_SHARED_LIBRARY)
endif

