#ifndef RTK_CDCA_H
#define RTK_CDCA_H

#include <pthread.h>
#include "Irtk_CaIntf.h"
#include "cdca_rDebug.h"
#include "CDCASS.h"
#include "rtk_porting_util.h"

#include "cdca_common.h"
#include "cdca_sys.h"

#include <functional>


#ifdef __cplusplus
extern "C" {
#endif

#define MAX_STREAM_PID_NUM (8)
#define MAX_CHANNEL_NUM  (8)
#define MAX_ECM_NUM (8)
typedef struct
{
    uint16_t  ecm_pid;
    uint16_t  tsid;
    uint8_t pidNum;
    uint16_t stream_pid[MAX_STREAM_PID_NUM];
}st_cdca_ecmStream_info;

typedef struct
{
     int descramble_id;
     uint32_t tsidBase;
     int source_handle;
     int ecm_num; //tsid_num/pservice_num, sum of ecm for all channel  <= 8;
     SCDCASServiceInfo* pServiceInfo[MAX_ECM_NUM];
}st_cdca_channel_info;

typedef struct
{
    uint32_t tsidBase;
    bool bUsing;
}st_cdca_tsid_info;

class Rtk_CDCA : public Irtk_CaIntf
{

public:
	static Rtk_CDCA * getInstance();
    	Rtk_CDCA();
	~Rtk_CDCA();

private:
	Rtk_CDCA(const Rtk_CDCA &) = delete;
	Rtk_CDCA & operator=(const Rtk_CDCA&) = delete;

public:

	/**
	 * Virtual Functions.
	 */
	virtual int Init();
	virtual int UnInit();
	
	virtual int DescramblerInit(int descramble_id);
	virtual int DescramblerUninit(int descramble_id);
	virtual int SetEmmPid(uint16_t caSystemId, uint16_t pid, int source_handle);
	
	virtual int StartDescramble(int descramble_id, RTKCA_Descramble_ECM_info_t &ecm_info);
	virtual int StopDescramble(int descramble_id);

	virtual int RegsiterEventCallback(int descramble_id, RTK_CaIntfCallback_t pfunc);
	virtual int UnRegsiterEventCallback(int descramble_id);

	virtual uint16_t GetCaSystemID(void) ;

	virtual int DVRCipherInit(int id);
	virtual int DVRCipherUnInit(int id);
	virtual int DVRCipherGetDataAglin(int id, uint32_t *alignBytes);
	virtual int DVRCipherConfig(int id, RTKCA_DvrCipher_config_t cfg);
	virtual int DVRCipherContinuityReset(int id, int64_t conti_ofs);
	virtual int DVRCipherEnc(int id, uint8_t *inbuf, uint8_t *outbuf, uint32_t size);
	virtual int DVRCipherDec(int id, uint8_t *inbuf, uint8_t *outbuf, uint32_t size);

private:

        //static Rtk_CDCA* m_pSingleton;
        static pthread_mutex_t mutex;
        static st_cdca_tsid_info m_tsidBase[MAX_CHANNEL_NUM];    
        st_cdca_channel_info m_pChannelInfo[MAX_CHANNEL_NUM];
        uint16_t m_emmPid;
	bool m_initialized;
        bool m_bSeparateSetEmm;

       int descramblingChCount();
       void refreshChEcmPids();
       void freeChannelInfo(int index);
       int getAvailChannelInfoIdx();
       void parseEcmStreamInfo(RTKCA_Descramble_ECM_info_t &ecm_info, uint32_t* tsidBase, st_cdca_ecmStream_info* pEcmStreamInfo, int* ecmCount);
       int mapEcmInfo2ChannelInfo(uint32_t tsidBase, int descramble_id, RTKCA_Descramble_ECM_info_t &ecm_info, int ecmCount,  st_cdca_ecmStream_info* pEcmStreamInfo);
       uint32_t genTsidBase();
       void resetTsidBase(uint32_t tsidBase);
       void uninit();
       void setEmmPid(uint16_t pid, int source_handle);

// ===================================================================================================
public:

    static void CDSTBCA_ActionRequestExt(CDCA_U16 wTVSID, CDCA_U8 byActionType, CDCA_U8 byLen, CDCA_U8* pbyData);
    static void CDSTBCA_ContinuesWatchLimit(CDCA_U8 byType, CDCA_U16 wWorkTime, CDCA_U16 wStopTime);
    static void CDSTBCA_DetitleReceived(CDCA_U8 bstatus);
    static void CDSTBCA_EmailNotifyIcon(CDCA_U8 byShow, CDCA_U32 dwEmailID);
    static void CDSTBCA_EntitleChanged(CDCA_U16 wTvsID);
    static void CDSTBCA_HideIPPVDlg(CDCA_U16 wEcmPid);
    static void CDSTBCA_HideOSDMessage(CDCA_U8 byStyle);
    static void CDSTBCA_RequestFeeding(CDCA_BOOL bReadStatus);
    static void CDSTBCA_ShowBuyMessage(CDCA_U16 wEcmPID, CDCA_U8  byMessageType);
    static void CDSTBCA_ShowCurtainNotify(CDCA_U16 wEcmPID, CDCA_U16 wCurtainCode);
    static void CDSTBCA_ShowFingerMessageExt(CDCA_U16 wEcmPID, char* fingerMsg);
    static void CDSTBCA_ShowOSDMessage(CDCA_U8 byStyle, const char* szMessage);
    static void CDSTBCA_ShowProgressStrip(CDCA_U8 byProgress, CDCA_U8 byMark);
    static void CDSTBCA_UNLockService(void);

#ifdef ENABLE_VENDOR_LIB
    static void CDSTBCA_LockService(const SCDCALockService* pLockService);
    static void CDSTBCA_ShowFingerInfo(CDCA_U16 wEcmPID, const SCDCAFingerInfo* pFingerInfo);
    static void CDSTBCA_ShowOSDInfo(SCDCAOSDInfo *pOSDInfo);
    static void CDSTBCA_StartIppvBuyDlg(CDCA_U8 byMessageType, CDCA_U16 wEcmPid, const SCDCAIppvBuyInfo* pIppvProgram);

#endif

    void registerOnActionRequestExtCallback (std::function<void(CDCA_U16, CDCA_U8, CDCA_U8, CDCA_U8 *)> callbackFn);
    void registerOnContinuesWatchLimitCallback (std::function<void(CDCA_U8, CDCA_U16, CDCA_U16)> callbackFn);
    void registerOnDetitleReceivedCallback (std::function<void(CDCA_U8)> callbackFn);
    void registerOnEmailNotifyIconCallback (std::function<void(CDCA_U8, CDCA_U32)> callbackFn);
    void registerOnEntitleChangedCallback (std::function<void(CDCA_U16)> callbackFn);
    void registerOnHideIPPVDlgCallback (std::function<void(CDCA_U16)> callbackFn);
    void registerOnHideOSDMessageCallback (std::function<void(CDCA_U8)> callbackFn);
    void registerOnRequestFeedingCallback (std::function<void(CDCA_BOOL)> callbackFn);
    void registerOnShowBuyMessageCallback (std::function<void(CDCA_U16, CDCA_U8)> callbackFn);
    void registerOnShowCurtainNotifyCallback (std::function<void(CDCA_U16, CDCA_U16)> callbackFn);
    void registerOnShowFingerMessageExtCallback (std::function<void(CDCA_U16, char *)> callbackFn);
    void registerOnShowOSDMessageCallback (std::function<void(CDCA_U8, const char *)> callbackFn);
    void registerOnShowProgressStripCallback (std::function<void(CDCA_U8, CDCA_U8)> callbackFn);
    void registerOnUNLockServiceCallback (std::function<void(void)> callbackFn);
#ifdef ENABLE_VENDOR_LIB
    void registerOnLockServiceCallback (std::function<void(const SCDCALockService *)> callbackFn);
    void registerOnShowFingerInfoCallback (std::function<void(CDCA_U16, const SCDCAFingerInfo *)> callbackFn);
    void registerOnShowOSDInfoCallback (std::function<void(SCDCAOSDInfo *)> callbackFn);
    void registerOnStartIppvBuyDlgCallback (std::function<void(CDCA_U8, CDCA_U16, const SCDCAIppvBuyInfo *)> callbackFn);
#endif

protected:
    virtual void actionRequestExt(CDCA_U16 wTVSID, CDCA_U8 byActionType, CDCA_U8 byLen, CDCA_U8* pbyData);
    virtual void continuesWatchLimit(CDCA_U8 byType, CDCA_U16 wWorkTime, CDCA_U16 wStopTime);
    virtual void detitleReceived(CDCA_U8 bstatus);
    virtual void emailNotifyIcon(CDCA_U8 byShow, CDCA_U32 dwEmailID);
    virtual void entitleChanged(CDCA_U16 wTvsID);
    virtual void hideIPPVDlg(CDCA_U16 wEcmPid);
    virtual void hideOSDMessage (CDCA_U8 byStyle);
    virtual void requestFeeding(CDCA_BOOL bReadStatus);
    virtual void showBuyMessage (CDCA_U16 wEcmPID, CDCA_U8 byMessageType);
    virtual void showCurtainNotify(CDCA_U16 wEcmPID, CDCA_U16 wCurtainCode);
    virtual void showFingerMessageExt(CDCA_U16 wEcmPID, char* fingerMsg);
    virtual void showOSDMessage (CDCA_U8 byStyle, const char * szMessage);
    virtual void showProgressStrip(CDCA_U8 byProgress, CDCA_U8 byMark);
    virtual void unlockService(void);
    
#ifdef ENABLE_VENDOR_LIB
    virtual void lockService(const SCDCALockService* pLockService);
    virtual void showFingerInfo(CDCA_U16 wEcmPID, const SCDCAFingerInfo* pFingerInfo);
    virtual void showOSDInfo (SCDCAOSDInfo *pOSDInfo);
    virtual void startIppvBuyDlg(CDCA_U8 byMessageType, CDCA_U16 wEcmPid, const SCDCAIppvBuyInfo* pIppvProgram);
#endif

protected:
    std::function<void(CDCA_U16, CDCA_U8, CDCA_U8, CDCA_U8 *)> m_onActionRequestExtFn;
    std::function<void(CDCA_U8, CDCA_U16, CDCA_U16)> m_onContinuesWatchLimitFn;
    std::function<void(CDCA_U8)> m_onDetitleReceivedFn;
    std::function<void(CDCA_U8, CDCA_U32)> m_onEmailNotifyIconFn;
    std::function<void(CDCA_U16)> m_onEntitleChangedFn;
    std::function<void(CDCA_U16)> m_onHideIPPVDlgFn;
    std::function<void(CDCA_U8)> m_onHideOSDMessageFn;
    std::function<void(CDCA_BOOL)> m_onRequestFeedingFn;
    std::function<void(CDCA_U16, CDCA_U8)> m_onShowBuyMessageFn;
    std::function<void(CDCA_U16, CDCA_U16)> m_onShowCurtainNotifyFn;
    std::function<void(CDCA_U16, char *)> m_onShowFingerMessageExtFn;
#ifdef ENABLE_VENDOR_LIB
    std::function<void(CDCA_U16, const SCDCAFingerInfo *)> m_onShowFingerInfoFn;
    std::function<void(const SCDCALockService *)> m_onLockServiceFn;
    std::function<void(SCDCAOSDInfo *)> m_onShowOSDInfoFn;
    std::function<void(CDCA_U8, CDCA_U16, const SCDCAIppvBuyInfo*)> m_onStartIppvBuyDlgFn;
#endif
    std::function<void(CDCA_U8, const char *)> m_onShowOSDMessageFn;
    std::function<void(CDCA_U8, CDCA_U8)> m_onShowProgressStripFn;
    std::function<void(void)> m_onUNLockServiceFn;
// ===================================================================================================

};

#ifdef __cplusplus
}
#endif

#endif  //RTK_CDCA_H

